package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Zapomoga;
import pl.topteam.dps.model.main.ZapomogaCriteria;

public abstract interface ZapomogaMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ZapomogaSqlProvider.class, method="countByExample")
    int countByExample(ZapomogaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=ZapomogaSqlProvider.class, method="deleteByExample")
    int deleteByExample(ZapomogaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from ZAPOMOGA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into ZAPOMOGA (EWIDENCJA_ID, RODZAJ_ZAPOMOGI_ID, ",
        "DATA_UDZIELENIA, KWOTA)",
        "values (#{ewidencjaId,jdbcType=BIGINT}, #{rodzajZapomogiId,jdbcType=BIGINT}, ",
        "#{dataUdzielenia,jdbcType=DATE}, #{kwota,jdbcType=DECIMAL})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Zapomoga record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(Zapomoga record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=ZapomogaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Zapomoga record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ZapomogaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="EWIDENCJA_ID", property="ewidencjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="RODZAJ_ZAPOMOGI_ID", property="rodzajZapomogiId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_UDZIELENIA", property="dataUdzielenia", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL)
    })
    List<Zapomoga> selectByExampleWithRowbounds(ZapomogaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ZapomogaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="EWIDENCJA_ID", property="ewidencjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="RODZAJ_ZAPOMOGI_ID", property="rodzajZapomogiId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_UDZIELENIA", property="dataUdzielenia", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL)
    })
    List<Zapomoga> selectByExample(ZapomogaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, EWIDENCJA_ID, RODZAJ_ZAPOMOGI_ID, DATA_UDZIELENIA, KWOTA",
        "from ZAPOMOGA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="EWIDENCJA_ID", property="ewidencjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="RODZAJ_ZAPOMOGI_ID", property="rodzajZapomogiId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_UDZIELENIA", property="dataUdzielenia", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL)
    })
    Zapomoga selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ZapomogaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Zapomoga record, @Param("example") ZapomogaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ZapomogaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Zapomoga record, @Param("example") ZapomogaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ZapomogaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Zapomoga record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update ZAPOMOGA",
        "set EWIDENCJA_ID = #{ewidencjaId,jdbcType=BIGINT},",
          "RODZAJ_ZAPOMOGI_ID = #{rodzajZapomogiId,jdbcType=BIGINT},",
          "DATA_UDZIELENIA = #{dataUdzielenia,jdbcType=DATE},",
          "KWOTA = #{kwota,jdbcType=DECIMAL}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Zapomoga record);
}