package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZestawienieWinienMaPozycja;
import pl.topteam.dps.model.main_gen.ZestawienieWinienMaPozycjaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZestawienieWinienMaPozycjaCriteria.Criterion;
import pl.topteam.dps.model.main.ZestawienieWinienMaPozycjaCriteria;

public class ZestawienieWinienMaPozycjaSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(ZestawienieWinienMaPozycjaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(ZestawienieWinienMaPozycjaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(ZestawienieWinienMaPozycja record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        
        if (record.getInstytucjaId() != null) {
            sql.VALUES("INSTYTUCJA_ID", "#{instytucjaId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getMieszkaniecId() != null) {
            sql.VALUES("MIESZKANIEC_ID", "#{mieszkaniecId,jdbcType=BIGINT}");
        }
        
        if (record.getPoprzedniaPozycjaId() != null) {
            sql.VALUES("POPRZEDNIA_POZYCJA_ID", "#{poprzedniaPozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getZestawienieId() != null) {
            sql.VALUES("ZESTAWIENIE_ID", "#{zestawienieId,jdbcType=BIGINT}");
        }
        
        if (record.getDataGenerowania() != null) {
            sql.VALUES("DATA_GENEROWANIA", "#{dataGenerowania,jdbcType=DATE}");
        }
        
        if (record.getKwotaWinienSk() != null) {
            sql.VALUES("KWOTA_WINIEN_SK", "#{kwotaWinienSk,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaMaSk() != null) {
            sql.VALUES("KWOTA_MA_SK", "#{kwotaMaSk,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaOdpisy() != null) {
            sql.VALUES("KWOTA_ODPISY", "#{kwotaOdpisy,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaPrzypisy() != null) {
            sql.VALUES("KWOTA_PRZYPISY", "#{kwotaPrzypisy,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaWplaty() != null) {
            sql.VALUES("KWOTA_WPLATY", "#{kwotaWplaty,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaZwroty() != null) {
            sql.VALUES("KWOTA_ZWROTY", "#{kwotaZwroty,jdbcType=DECIMAL}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(ZestawienieWinienMaPozycjaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("INSTYTUCJA_ID");
        sql.SELECT("OSOBA_ID");
        sql.SELECT("MIESZKANIEC_ID");
        sql.SELECT("POPRZEDNIA_POZYCJA_ID");
        sql.SELECT("ZESTAWIENIE_ID");
        sql.SELECT("DATA_GENEROWANIA");
        sql.SELECT("KWOTA_WINIEN_SK");
        sql.SELECT("KWOTA_MA_SK");
        sql.SELECT("KWOTA_ODPISY");
        sql.SELECT("KWOTA_PRZYPISY");
        sql.SELECT("KWOTA_WPLATY");
        sql.SELECT("KWOTA_ZWROTY");
        sql.FROM("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZestawienieWinienMaPozycja record = (ZestawienieWinienMaPozycja) parameter.get("record");
        ZestawienieWinienMaPozycjaCriteria example = (ZestawienieWinienMaPozycjaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getInstytucjaId() != null) {
            sql.SET("INSTYTUCJA_ID = #{record.instytucjaId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getMieszkaniecId() != null) {
            sql.SET("MIESZKANIEC_ID = #{record.mieszkaniecId,jdbcType=BIGINT}");
        }
        
        if (record.getPoprzedniaPozycjaId() != null) {
            sql.SET("POPRZEDNIA_POZYCJA_ID = #{record.poprzedniaPozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getZestawienieId() != null) {
            sql.SET("ZESTAWIENIE_ID = #{record.zestawienieId,jdbcType=BIGINT}");
        }
        
        if (record.getDataGenerowania() != null) {
            sql.SET("DATA_GENEROWANIA = #{record.dataGenerowania,jdbcType=DATE}");
        }
        
        if (record.getKwotaWinienSk() != null) {
            sql.SET("KWOTA_WINIEN_SK = #{record.kwotaWinienSk,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaMaSk() != null) {
            sql.SET("KWOTA_MA_SK = #{record.kwotaMaSk,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaOdpisy() != null) {
            sql.SET("KWOTA_ODPISY = #{record.kwotaOdpisy,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaPrzypisy() != null) {
            sql.SET("KWOTA_PRZYPISY = #{record.kwotaPrzypisy,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaWplaty() != null) {
            sql.SET("KWOTA_WPLATY = #{record.kwotaWplaty,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaZwroty() != null) {
            sql.SET("KWOTA_ZWROTY = #{record.kwotaZwroty,jdbcType=DECIMAL}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("INSTYTUCJA_ID = #{record.instytucjaId,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("MIESZKANIEC_ID = #{record.mieszkaniecId,jdbcType=BIGINT}");
        sql.SET("POPRZEDNIA_POZYCJA_ID = #{record.poprzedniaPozycjaId,jdbcType=BIGINT}");
        sql.SET("ZESTAWIENIE_ID = #{record.zestawienieId,jdbcType=BIGINT}");
        sql.SET("DATA_GENEROWANIA = #{record.dataGenerowania,jdbcType=DATE}");
        sql.SET("KWOTA_WINIEN_SK = #{record.kwotaWinienSk,jdbcType=DECIMAL}");
        sql.SET("KWOTA_MA_SK = #{record.kwotaMaSk,jdbcType=DECIMAL}");
        sql.SET("KWOTA_ODPISY = #{record.kwotaOdpisy,jdbcType=DECIMAL}");
        sql.SET("KWOTA_PRZYPISY = #{record.kwotaPrzypisy,jdbcType=DECIMAL}");
        sql.SET("KWOTA_WPLATY = #{record.kwotaWplaty,jdbcType=DECIMAL}");
        sql.SET("KWOTA_ZWROTY = #{record.kwotaZwroty,jdbcType=DECIMAL}");
        
        ZestawienieWinienMaPozycjaCriteria example = (ZestawienieWinienMaPozycjaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(ZestawienieWinienMaPozycja record) {
        SQL sql = new SQL();
        sql.UPDATE("ZESTAWIENIE_WINIEN_MA_POZYCJA");
        
        if (record.getInstytucjaId() != null) {
            sql.SET("INSTYTUCJA_ID = #{instytucjaId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getMieszkaniecId() != null) {
            sql.SET("MIESZKANIEC_ID = #{mieszkaniecId,jdbcType=BIGINT}");
        }
        
        if (record.getPoprzedniaPozycjaId() != null) {
            sql.SET("POPRZEDNIA_POZYCJA_ID = #{poprzedniaPozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getZestawienieId() != null) {
            sql.SET("ZESTAWIENIE_ID = #{zestawienieId,jdbcType=BIGINT}");
        }
        
        if (record.getDataGenerowania() != null) {
            sql.SET("DATA_GENEROWANIA = #{dataGenerowania,jdbcType=DATE}");
        }
        
        if (record.getKwotaWinienSk() != null) {
            sql.SET("KWOTA_WINIEN_SK = #{kwotaWinienSk,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaMaSk() != null) {
            sql.SET("KWOTA_MA_SK = #{kwotaMaSk,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaOdpisy() != null) {
            sql.SET("KWOTA_ODPISY = #{kwotaOdpisy,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaPrzypisy() != null) {
            sql.SET("KWOTA_PRZYPISY = #{kwotaPrzypisy,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaWplaty() != null) {
            sql.SET("KWOTA_WPLATY = #{kwotaWplaty,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaZwroty() != null) {
            sql.SET("KWOTA_ZWROTY = #{kwotaZwroty,jdbcType=DECIMAL}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, ZestawienieWinienMaPozycjaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}