package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.ZleceniePrzedmiot;
import pl.topteam.dps.model.main.ZleceniePrzedmiotCriteria;

public abstract interface ZleceniePrzedmiotMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ZleceniePrzedmiotSqlProvider.class, method="countByExample")
    int countByExample(ZleceniePrzedmiotCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=ZleceniePrzedmiotSqlProvider.class, method="deleteByExample")
    int deleteByExample(ZleceniePrzedmiotCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from ZLECENIE_PRZEDMIOT",
        "where ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long zlecenieId);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into ZLECENIE_PRZEDMIOT (ZLECENIE_ID, INFO_DOBOR, ",
        "KOD, LICZBA_SZTUK, ",
        "NAZWA)",
        "values (#{zlecenieId,jdbcType=BIGINT}, #{infoDobor,jdbcType=VARCHAR}, ",
        "#{kod,jdbcType=VARCHAR}, #{liczbaSztuk,jdbcType=INTEGER}, ",
        "#{nazwa,jdbcType=VARCHAR})"
    })
    int insert(ZleceniePrzedmiot record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(ZleceniePrzedmiot record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=ZleceniePrzedmiotSqlProvider.class, method="insertSelective")
    int insertSelective(ZleceniePrzedmiot record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ZleceniePrzedmiotSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ZLECENIE_ID", property="zlecenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INFO_DOBOR", property="infoDobor", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZBA_SZTUK", property="liczbaSztuk", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<ZleceniePrzedmiot> selectByExampleWithRowbounds(ZleceniePrzedmiotCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ZleceniePrzedmiotSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ZLECENIE_ID", property="zlecenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INFO_DOBOR", property="infoDobor", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZBA_SZTUK", property="liczbaSztuk", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<ZleceniePrzedmiot> selectByExample(ZleceniePrzedmiotCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ZLECENIE_ID, INFO_DOBOR, KOD, LICZBA_SZTUK, NAZWA",
        "from ZLECENIE_PRZEDMIOT",
        "where ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ZLECENIE_ID", property="zlecenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INFO_DOBOR", property="infoDobor", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZBA_SZTUK", property="liczbaSztuk", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    ZleceniePrzedmiot selectByPrimaryKey(Long zlecenieId);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ZleceniePrzedmiotSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") ZleceniePrzedmiot record, @Param("example") ZleceniePrzedmiotCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ZleceniePrzedmiotSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") ZleceniePrzedmiot record, @Param("example") ZleceniePrzedmiotCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ZleceniePrzedmiotSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(ZleceniePrzedmiot record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update ZLECENIE_PRZEDMIOT",
        "set INFO_DOBOR = #{infoDobor,jdbcType=VARCHAR},",
          "KOD = #{kod,jdbcType=VARCHAR},",
          "LICZBA_SZTUK = #{liczbaSztuk,jdbcType=INTEGER},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR}",
        "where ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(ZleceniePrzedmiot record);
}