package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZlecenieSoczewka;
import pl.topteam.dps.model.main_gen.ZlecenieSoczewkaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZlecenieSoczewkaCriteria.Criterion;
import pl.topteam.dps.model.main.ZlecenieSoczewkaCriteria;

public class ZlecenieSoczewkaSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(ZlecenieSoczewkaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZLECENIE_SOCZEWKA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(ZlecenieSoczewkaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZLECENIE_SOCZEWKA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(ZlecenieSoczewka record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZLECENIE_SOCZEWKA");
        
        if (record.getZlecenieId() != null) {
            sql.VALUES("ZLECENIE_ID", "#{zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzaj() != null) {
            sql.VALUES("RODZAJ", "#{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getOlSfera() != null) {
            sql.VALUES("OL_SFERA", "#{olSfera,jdbcType=DECIMAL}");
        }
        
        if (record.getOlCylinder() != null) {
            sql.VALUES("OL_CYLINDER", "#{olCylinder,jdbcType=DECIMAL}");
        }
        
        if (record.getOlOs() != null) {
            sql.VALUES("OL_OS", "#{olOs,jdbcType=DECIMAL}");
        }
        
        if (record.getOlPryzma() != null) {
            sql.VALUES("OL_PRYZMA", "#{olPryzma,jdbcType=DECIMAL}");
        }
        
        if (record.getOpSfera() != null) {
            sql.VALUES("OP_SFERA", "#{opSfera,jdbcType=DECIMAL}");
        }
        
        if (record.getOpCylinder() != null) {
            sql.VALUES("OP_CYLINDER", "#{opCylinder,jdbcType=DECIMAL}");
        }
        
        if (record.getOpOs() != null) {
            sql.VALUES("OP_OS", "#{opOs,jdbcType=DECIMAL}");
        }
        
        if (record.getOpPryzma() != null) {
            sql.VALUES("OP_PRYZMA", "#{opPryzma,jdbcType=DECIMAL}");
        }
        
        if (record.getOdlZrenic() != null) {
            sql.VALUES("ODL_ZRENIC", "#{odlZrenic,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(ZlecenieSoczewkaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ZLECENIE_ID");
        } else {
            sql.SELECT("ZLECENIE_ID");
        }
        sql.SELECT("RODZAJ");
        sql.SELECT("OL_SFERA");
        sql.SELECT("OL_CYLINDER");
        sql.SELECT("OL_OS");
        sql.SELECT("OL_PRYZMA");
        sql.SELECT("OP_SFERA");
        sql.SELECT("OP_CYLINDER");
        sql.SELECT("OP_OS");
        sql.SELECT("OP_PRYZMA");
        sql.SELECT("ODL_ZRENIC");
        sql.FROM("ZLECENIE_SOCZEWKA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZlecenieSoczewka record = (ZlecenieSoczewka) parameter.get("record");
        ZlecenieSoczewkaCriteria example = (ZlecenieSoczewkaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_SOCZEWKA");
        
        if (record.getZlecenieId() != null) {
            sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getOlSfera() != null) {
            sql.SET("OL_SFERA = #{record.olSfera,jdbcType=DECIMAL}");
        }
        
        if (record.getOlCylinder() != null) {
            sql.SET("OL_CYLINDER = #{record.olCylinder,jdbcType=DECIMAL}");
        }
        
        if (record.getOlOs() != null) {
            sql.SET("OL_OS = #{record.olOs,jdbcType=DECIMAL}");
        }
        
        if (record.getOlPryzma() != null) {
            sql.SET("OL_PRYZMA = #{record.olPryzma,jdbcType=DECIMAL}");
        }
        
        if (record.getOpSfera() != null) {
            sql.SET("OP_SFERA = #{record.opSfera,jdbcType=DECIMAL}");
        }
        
        if (record.getOpCylinder() != null) {
            sql.SET("OP_CYLINDER = #{record.opCylinder,jdbcType=DECIMAL}");
        }
        
        if (record.getOpOs() != null) {
            sql.SET("OP_OS = #{record.opOs,jdbcType=DECIMAL}");
        }
        
        if (record.getOpPryzma() != null) {
            sql.SET("OP_PRYZMA = #{record.opPryzma,jdbcType=DECIMAL}");
        }
        
        if (record.getOdlZrenic() != null) {
            sql.SET("ODL_ZRENIC = #{record.odlZrenic,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_SOCZEWKA");
        
        sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        sql.SET("OL_SFERA = #{record.olSfera,jdbcType=DECIMAL}");
        sql.SET("OL_CYLINDER = #{record.olCylinder,jdbcType=DECIMAL}");
        sql.SET("OL_OS = #{record.olOs,jdbcType=DECIMAL}");
        sql.SET("OL_PRYZMA = #{record.olPryzma,jdbcType=DECIMAL}");
        sql.SET("OP_SFERA = #{record.opSfera,jdbcType=DECIMAL}");
        sql.SET("OP_CYLINDER = #{record.opCylinder,jdbcType=DECIMAL}");
        sql.SET("OP_OS = #{record.opOs,jdbcType=DECIMAL}");
        sql.SET("OP_PRYZMA = #{record.opPryzma,jdbcType=DECIMAL}");
        sql.SET("ODL_ZRENIC = #{record.odlZrenic,jdbcType=INTEGER}");
        
        ZlecenieSoczewkaCriteria example = (ZlecenieSoczewkaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(ZlecenieSoczewka record) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_SOCZEWKA");
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getOlSfera() != null) {
            sql.SET("OL_SFERA = #{olSfera,jdbcType=DECIMAL}");
        }
        
        if (record.getOlCylinder() != null) {
            sql.SET("OL_CYLINDER = #{olCylinder,jdbcType=DECIMAL}");
        }
        
        if (record.getOlOs() != null) {
            sql.SET("OL_OS = #{olOs,jdbcType=DECIMAL}");
        }
        
        if (record.getOlPryzma() != null) {
            sql.SET("OL_PRYZMA = #{olPryzma,jdbcType=DECIMAL}");
        }
        
        if (record.getOpSfera() != null) {
            sql.SET("OP_SFERA = #{opSfera,jdbcType=DECIMAL}");
        }
        
        if (record.getOpCylinder() != null) {
            sql.SET("OP_CYLINDER = #{opCylinder,jdbcType=DECIMAL}");
        }
        
        if (record.getOpOs() != null) {
            sql.SET("OP_OS = #{opOs,jdbcType=DECIMAL}");
        }
        
        if (record.getOpPryzma() != null) {
            sql.SET("OP_PRYZMA = #{opPryzma,jdbcType=DECIMAL}");
        }
        
        if (record.getOdlZrenic() != null) {
            sql.SET("ODL_ZRENIC = #{odlZrenic,jdbcType=INTEGER}");
        }
        
        sql.WHERE("ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, ZlecenieSoczewkaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}