package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypParametruPracownika implements EnumOpis {
// JAWNE
	TYPY_PRZYPOMNIEN("przypominanie o", "przypominanie pracownikowi o różnych rzeczach", true),
	RAPORTY_WIDOCZNE("raporty widoczne", "raporty widoczne w menu głównym \"Raporty\"", true),
	MIESZKANIEC_LISTA("typ ewidencji mieszk. wyśw. na liście", "typ ewidencji jaki ma być uwzględniany przy wyświetlaniu listy mieszkańców (menu: Mieszkańcy -> Lista)", true),
	OSOBA_OCZEKUJACA_LISTA("typ ewidencji osób oczek. wyśw. na liście", "typ ewidencji jaki ma być uwzględniany przy wyświetlaniu listy osób oczekujących (menu: Oczekujący -> Lista)", true),
	/** Parametr powinien przybierać jedną z wartości {@link pl.topteam.dps.enums.DyzurPielegniarskiPracownik} */
	DYZUR_PIELEGNIARSKI("czy pracownika dotyczy dyżur pielęgniarski", "czy pracownika dotyczy dyżur pielęgniarski", true),
	/** Parametr powinien przybierać jedną z wartości {@link pl.topteam.dps.enums.ProstyPrzelacznik} */
	UMOWZLIW_POWROT_BACKSPACE("czy umożliwić cofanie stron", "czy umożliwić użycie przycisków sterowania w przeglądarce", true),
	/** Parametr powinien przybierać jedną z wartości {@link pl.topteam.dps.enums.ProstyPrzelacznik} */
	UMOWZLIW_POZYCZKA_LEKOW("czy stosować pożyczki leków", "czy umożliwić przez program wprowadzanie pożyczek leków pomiędzy mieszkańcami", true),
	/** Parametr powinien przybierać jedną z wartości {@link pl.topteam.dps.enums.ProstyPrzelacznik} */
	WYROZNIAJ_PRZYPOMNIENIA("czy wyróżniać przypomnienia", "czy wyróżnić kolorem odnośnik do listy przypomnień", true),

// UKRYTE PRZED UŻYTKOWNIKIEM
	// przedziały wiekowe dla raportu (podpowiadanie, żeby nie wpisywali bez przerwy)
	RAPORTY_PRZEDZIALY("", "", false),
	// opis raportu bilansu leków w magazynie doraźnym
	RAPORTY_MG_DORAZNY_OPIS_RAPORTU("", "", false),
	// oddział dla raportu bilansu leków w magazynie doraźnym
	RAPORTY_MG_DORAZNY_ODDZIAL("", "", false),
	// dla raportu rozliczeniowego w Excelu (V1)
	RAPORTY_RR_EXCEL_V1_EL_ROZL("", "", false),
	RAPORTY_RR_EXCEL_V1_INF_M("", "", false),
	RAPORTY_RR_EXCEL_V1_M("", "", false),
	RAPORTY_RR_EXCEL_V1_ARK("", "", false),

	// czy wyświetlono informację o ostatniej wersji (po jej zmianie)
	INFO_WERSJA_APLIKACJI("", "", false),
	// ostatnia wersja dla której wyświetlono zmiany po aktualizacji
	INFO_WERSJA_APLIKACJI_ZMIANY("", "", false)
	;

	private boolean jawny;
	private String skrot;
	private String opis;

	private TypParametruPracownika(String skrot, String opis, boolean jawny) {
		this.skrot = skrot;
		this.opis = opis;
		this.jawny = jawny;
	}

	public String getSkrot() {
		return skrot;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}

	public boolean isJawny() {
		return this.jawny;
	}
}
