package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypUprawnienia implements EnumOpis {
// uprawnienia użytkownika
	UZYTKOWNIK_PROGRAMU(GrupaUprawnien.WSZYSTKIE, ""),
	
// uprawnienia niewidoczne dla użytkowników programu
	KAT_USLUG_CZYNN(GrupaUprawnien.NIEWIDOCZNE_DLA_ADMINISTRATORA, ""),

// typy uprawnień w module ogólnym (niezależnie od rodzaju pracowników)
	AUTONUMERACJA(GrupaUprawnien.MODUL_OGOLNY, "autonumeracja"),
	FAKTURY(GrupaUprawnien.MODUL_OGOLNY, "faktury VAT"),
	INFOR_DOD_DEF(GrupaUprawnien.MODUL_OGOLNY, "informacja dodatkowa (definiowanie)"),
	INFOR_DOD_REAL(GrupaUprawnien.MODUL_OGOLNY, "informacja dodatkowa (wprowadzanie)"),
	INTERWENCJA_ORG_SCI(GrupaUprawnien.MODUL_OGOLNY, "interwencja organu ścigania"),
	INTERWENCJA_POG_RAT(GrupaUprawnien.MODUL_OGOLNY, "interwencja pogotowia ratunkowego"),
	KAT_USLUG(GrupaUprawnien.MODUL_OGOLNY, "katalog usług"),
	LISTA_OSOB(GrupaUprawnien.MODUL_OGOLNY, "lista osób (wyszukiwanie)"),
	MIESZKANIEC(GrupaUprawnien.MODUL_OGOLNY, "mieszkaniec (dane)"),
	MIEJSCE_POBYTU(GrupaUprawnien.MODUL_OGOLNY, "miejsce pobytu/skierowania osoby"),
	OCZEKUJACY(GrupaUprawnien.MODUL_OGOLNY, "osoba oczekująca (dane)"),
	ODWIEDZINY(GrupaUprawnien.MODUL_OGOLNY, "odwiedziny"),
	PLAN_WSPARCIA_MIESZKANCA(GrupaUprawnien.MODUL_OGOLNY, "plan wsparcia mieszkańca"),
	POMIAR_ALKOMATEM(GrupaUprawnien.MODUL_OGOLNY, "pomiar alkomatem"),
	RAPORTY(GrupaUprawnien.MODUL_OGOLNY, "raporty (lista dostępnych)"),
	SPRAWOZDANIE(GrupaUprawnien.MODUL_OGOLNY, "sprawozdania"),
	SZABLON_WYDRUKU(GrupaUprawnien.MODUL_OGOLNY, "szablony wydruku"),

// typy uprawnień w module socjalnym
	DEC_KIER(GrupaUprawnien.MODUL_SOCJALNY, "decyzja kierująca"),
	DEC_ALIM(GrupaUprawnien.MODUL_SOCJALNY, "decyzja o alimentacji"),
	DEC_ODPL(GrupaUprawnien.MODUL_SOCJALNY, "decyzja o odpłatności"),
	DEC_UCH(GrupaUprawnien.MODUL_SOCJALNY, "decyzja uchylająca"),
	DEC_UM(GrupaUprawnien.MODUL_SOCJALNY, "decyzja umieszczająca"),
	DEC_WYG(GrupaUprawnien.MODUL_SOCJALNY, "decyzja wygaszająca"),
	DEPOZYT(GrupaUprawnien.MODUL_SOCJALNY, "depozyt"),
	DWD_OS(GrupaUprawnien.MODUL_SOCJALNY, "dowód osobisty"),
	INSTYTUCJA_DOPLACAJACA(GrupaUprawnien.MODUL_SOCJALNY, "instytucja dopłacająca do utrzymania"),
	MELDUNEK(GrupaUprawnien.MODUL_SOCJALNY, "meldunek czasowy"),
	MIESZKANIEC_CZLR(GrupaUprawnien.MODUL_SOCJALNY, "członkowie rodziny mieszkańca"),
	NALICZANIE_ODPL(GrupaUprawnien.MODUL_SOCJALNY, "naliczanie odpłatności za pobyt"),
	NIEOBECNOSC(GrupaUprawnien.MODUL_SOCJALNY, "nieobecności"),
	NIEOBECNOSC_INFORMACJA(GrupaUprawnien.MODUL_SOCJALNY, "nieobecności/skierowania"),
	ODPIS(GrupaUprawnien.MODUL_SOCJALNY, "odpisy (odpłatność)"),
	ODPLATNOSC(GrupaUprawnien.MODUL_SOCJALNY, "odpłatność"),
	ORZECZ_NIEP(GrupaUprawnien.MODUL_SOCJALNY, "orzeczenia o niepełnosprawności"),
	POB_SWIAD(GrupaUprawnien.MODUL_SOCJALNY, "pobierane świadczenia"),
	POSTANOWIENIE_SADU(GrupaUprawnien.MODUL_SOCJALNY, "postanowienie sądu"),
	PRZELEW_DRUK(GrupaUprawnien.MODUL_SOCJALNY, "przelewy - druki"),
	SWIADCZENIE(GrupaUprawnien.MODUL_SOCJALNY, "świadczenie (def. usług)"),
	SWIADCZENIE_REALIZACJA(GrupaUprawnien.MODUL_SOCJALNY, "świadczenie (realizacja usług)"),
	SWIADCZENIE_ROZLICZENIA(GrupaUprawnien.MODUL_SOCJALNY, "świadczenie (rozliczenia)"),
	UMOWA(GrupaUprawnien.MODUL_SOCJALNY, "umowy o pobyt w domu"),
	WPLATY_PLATNOSC(GrupaUprawnien.MODUL_SOCJALNY, "wpłaty dla płatności"),
	ZAPOMOGA(GrupaUprawnien.MODUL_SOCJALNY, "zapomogi"),
	ZWROT(GrupaUprawnien.MODUL_SOCJALNY, "zwroty (odpłatność)"),

// typy uprawnień w module medycznym
	CZAS_PRACY_UV(GrupaUprawnien.MODUL_MEDYCZNY, "czas pracy lampy UV"),
	KWALIFIKACJA_PIEL(GrupaUprawnien.MODUL_MEDYCZNY, "kwalifikacja pielęgniarska"),
	MONITOROWANIE(GrupaUprawnien.MODUL_MEDYCZNY, "monitorowanie mieszkańców"),
	OCENA_WG_SKALI(GrupaUprawnien.MODUL_MEDYCZNY, "ocena mieszkańca wg skal"),
	ODPADY_MEDYCZNE(GrupaUprawnien.MODUL_MEDYCZNY, "odpady medyczne"),
	POBR_MATERIALU_BADANIA(GrupaUprawnien.MODUL_MEDYCZNY, "pobranie materiału do badań"),
	POMIAR_CISN_TETN(GrupaUprawnien.MODUL_MEDYCZNY, "pomiar ciśnienia tętniczego"),
	POMIAR_GLIKEMII(GrupaUprawnien.MODUL_MEDYCZNY, "pomiar glikemii"),
	POMIAR_TEMP_CIALA(GrupaUprawnien.MODUL_MEDYCZNY, "pomiar temperatury ciała"),
	RAPORT_DYZ_DEF(GrupaUprawnien.MODUL_MEDYCZNY, "raport dyżur pielęgniarski (definicja)"),
	RAPORT_DYZ(GrupaUprawnien.MODUL_MEDYCZNY, "raport dyżur pielęgniarski (tworzenie)"),
	REALIZACJA_WYROBOW_MED(GrupaUprawnien.MODUL_MEDYCZNY, "realizacja wyrobów medycznych"),
	SKALA_OCENY(GrupaUprawnien.MODUL_MEDYCZNY, "skala oceny pacjenta"),
	UMOWA_APTEKA(GrupaUprawnien.MODUL_MEDYCZNY, "umowa z apteką"),
	WYROB_MEDYCZNY(GrupaUprawnien.MODUL_MEDYCZNY, "wyroby medyczne"),
	WYROB_MED_FAKTURY(GrupaUprawnien.MODUL_MEDYCZNY, "wyroby medyczne (faktury VAT)"),
	ZALECENIE_LEKARSKIE(GrupaUprawnien.MODUL_MEDYCZNY, "zalecenia lekarskie"),
	ZEBRANIE_ZTO(GrupaUprawnien.MODUL_MEDYCZNY, "zebranie ZTO"),

// typy uprawnień w module leki
	DAWKOWANIE(GrupaUprawnien.MODUL_LEKI, "dawkowanie leków"),
	MG_DORAZNY(GrupaUprawnien.MODUL_LEKI, "magazyn 'apteka podręczna'"),
	MG_RECEPTY(GrupaUprawnien.MODUL_LEKI, "magazyn leków na recepty"),
	PORA_DNIA(GrupaUprawnien.MODUL_LEKI, "pory dnia podawania leków"),
	REALIZACJA_LEKOW(GrupaUprawnien.MODUL_LEKI, "realizacja leków"),
	RECEPTY(GrupaUprawnien.MODUL_LEKI, "recepty"),
	RECEPTY_FAKTURY(GrupaUprawnien.MODUL_LEKI, "recepty - faktury"),
	SLOWNIK_LEKOW(GrupaUprawnien.MODUL_LEKI, "słownik leków wykorzystywanych"),

// typy uprawnień w module administracyjnym
	AKTUALIZACJA_BAZY(GrupaUprawnien.ADMINISTRACJA, "aktualizacja bazy danych"),
	DANE_DPS(GrupaUprawnien.ADMINISTRACJA, "dane jednostki DPS"),
	DZIENNIK(GrupaUprawnien.ADMINISTRACJA, "dziennik operacji"),
	FORMAT(GrupaUprawnien.ADMINISTRACJA, "format plików importu"),
	GRUPA_PRACOW(GrupaUprawnien.ADMINISTRACJA, "grupy użytkowników"),
	IMPORT_ARISCO(GrupaUprawnien.ADMINISTRACJA, "import danych z ARISCO"),
	IMPORT_TTDOS(GrupaUprawnien.ADMINISTRACJA, "import danych z TT DOM (DOS)"),
	KOPIA_BAZY(GrupaUprawnien.ADMINISTRACJA, "kopia bazy danych"),
	PARAM_SYS(GrupaUprawnien.ADMINISTRACJA, "parametr systemowy"),
	POLITYKA_BEZPIECZENSTWA(GrupaUprawnien.ADMINISTRACJA, "polityka bezpieczeństwa"),
	PRACOWNIK(GrupaUprawnien.ADMINISTRACJA, "pracownicy"),
	SLOWO(GrupaUprawnien.ADMINISTRACJA, "słowa w słownikach"),
	TOMCAT_LOGI(GrupaUprawnien.ADMINISTRACJA, "Tomcat (pobranie logów serwera)"),
	ZADANIE_CZASOWE(GrupaUprawnien.ADMINISTRACJA, "zadania czasowe"),
	;

	private GrupaUprawnien grupaUprawnien;
	private String opis;

	private TypUprawnienia(GrupaUprawnien grupaUprawnien, String opis) {
		this.grupaUprawnien = grupaUprawnien;
		this.opis = opis;
	}
	
	public GrupaUprawnien getGrupaUprawnien() {
		return grupaUprawnien;
	}
	
	@Override
	public String getOpis() {
		return this.opis;
	}
}
