package pl.topteam.dps.model.main;

import java.math.BigDecimal;
import java.util.List;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "notaOdplatnoscPozycja",
		zmienne = {
			@ZmiennaWydruku(nazwa = "kwota", opis = "kwota pozycji"),
			@ZmiennaWydruku(nazwa = "kwotaOdpisu", opis = "kwota odpisu z pozycji"),
			@ZmiennaWydruku(nazwa = "osoba", id = "osoba", opis = "osoba, której dotyczy pozycja"),
			@ZmiennaWydruku(nazwa = "instytucjaDoplacajaca", id = "instytucjaDoplacajaca", opis = "instytucja, której dotyczy pozycja"),
			@ZmiennaWydruku(nazwa = "kontoBankowe", id = "kontoBankowe", opis = "konto bankowe zapisane dla pozycji"),
			@ZmiennaWydruku(nazwa = "zadluzenie", id = "zadluzenie", opis = "informacja o okresie zadłużenia")
		}
	)
public class NotaOdplatnoscPozycja extends pl.topteam.dps.model.main_gen.NotaOdplatnoscPozycja {
	private static final long serialVersionUID = 2810887732786720209L;

	private Osoba mieszkaniec;
	private Osoba osoba;
	private InstytucjaDoplacajaca instytucjaDoplacajaca;
	private KontoBankowe kontoBankowe;
	private Zadluzenie zadluzenie;
	private Nieobecnosc nieobecnosc;

	private BigDecimal kwotaWplaty;
	private BigDecimal kwotaZwrotu;

	private List<ZadluzenieWyrownanie> listaWyrownan;

	public Osoba getMieszkaniec() {
		return mieszkaniec;
	}

	public void setMieszkaniec(Osoba mieszkaniec) {
		this.mieszkaniec = mieszkaniec;
	}

	public Osoba getOsoba() {
		return osoba;
	}

	public void setOsoba(Osoba osoba) {
		this.osoba = osoba;
	}

	public InstytucjaDoplacajaca getInstytucjaDoplacajaca() {
		return instytucjaDoplacajaca;
	}

	public void setInstytucjaDoplacajaca(InstytucjaDoplacajaca instytucjaDoplacajaca) {
		this.instytucjaDoplacajaca = instytucjaDoplacajaca;
	}

	public KontoBankowe getKontoBankowe() {
		return kontoBankowe;
	}

	public void setKontoBankowe(KontoBankowe kontoBankowe) {
		this.kontoBankowe = kontoBankowe;
	}

	public BigDecimal getKwotaWplaty() {
		return kwotaWplaty;
	}

	public void setKwotaWplaty(BigDecimal kwotaWplaty) {
		this.kwotaWplaty = kwotaWplaty;
	}

	public BigDecimal getKwotaZwrotu() {
		return kwotaZwrotu;
	}

	public void setKwotaZwrotu(BigDecimal kwotaZwrotu) {
		this.kwotaZwrotu = kwotaZwrotu;
	}

	public Zadluzenie getZadluzenie() {
		return zadluzenie;
	}

	public void setZadluzenie(Zadluzenie zadluzenie) {
		this.zadluzenie = zadluzenie;
	}

	public Nieobecnosc getNieobecnosc() {
		return nieobecnosc;
	}

	public void setNieobecnosc(Nieobecnosc nieobecnosc) {
		this.nieobecnosc = nieobecnosc;
	}

	public List<ZadluzenieWyrownanie> getListaWyrownan() {
		return listaWyrownan;
	}

	public void setListaWyrownan(List<ZadluzenieWyrownanie> listaWyrownan) {
		this.listaWyrownan = listaWyrownan;
	}
}