package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
public class OsobaPracownik extends pl.topteam.dps.model.main_gen.OsobaPracownik {
	private static final long serialVersionUID = -6159746781670225425L;

	/**
	 * Pracownik, który jest przypisany do wskazanej osoby
	 */
	@ZmiennaWydrukuPominPole
	private Pracownik pracownikPrzypisany;
	
	/**
	 * Pracownik, który przypisał ww. pracownika do osoby
	 */
	@ZmiennaWydrukuPominPole
	private Pracownik pracownikPrzypisal;
	
	/**
	 * Pracownik, który zmienił wpis dla tego przypisania
	 */
	@ZmiennaWydrukuPominPole
	private Pracownik pracownikZmienil;


	public Pracownik getPracownikPrzypisany() {
		return pracownikPrzypisany;
	}

	public void setPracownikPrzypisany(Pracownik pracownikPrzypisany) {
		this.pracownikPrzypisany = pracownikPrzypisany;
	}

	public Pracownik getPracownikZmienil() {
		return pracownikZmienil;
	}

	public void setPracownikZmienil(Pracownik pracownikZmienil) {
		this.pracownikZmienil = pracownikZmienil;
	}

	public Pracownik getPracownikPrzypisal() {
		return pracownikPrzypisal;
	}

	public void setPracownikPrzypisal(Pracownik pracownikPrzypisal) {
		this.pracownikPrzypisal = pracownikPrzypisal;
	}
}