package pl.topteam.utils.wydruki.zmienne.model.wrapper;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;

import pl.topteam.utils.wydruki.zmienne.enums.UzycieZmiennej;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaUdostepniana;

public class ZmiennaUdostepnianaWrapper implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6159746781670225425L;

	private ZmiennaUdostepniana zmiennaUdostepniana;

	public ZmiennaUdostepnianaWrapper(ZmiennaUdostepniana zmiennaUdostepniana) {
		this.zmiennaUdostepniana = zmiennaUdostepniana;
	}
	
	public String getNazwaZmiennej() {
		return zmiennaUdostepniana.nazwaZmiennej();
	}
	
	public UzycieZmiennej getMiejsceUzycia() {
		return zmiennaUdostepniana.miejsceUzycia();
	}

	public String getId() {
		return zmiennaUdostepniana.id();
	}

	public String getOpis() {
		return zmiennaUdostepniana.opis();
	}
	
	@Override
	public String toString() {
		if(zmiennaUdostepniana != null) {
			return new ToStringBuilder(zmiennaUdostepniana)
				.append("id", zmiennaUdostepniana.id())
				.append("nazwaZmiennej", zmiennaUdostepniana.nazwaZmiennej())
				.append("opis", zmiennaUdostepniana.miejsceUzycia())
				.toString();
		}
		
		return null;
	}
}
