/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;
import pl.topteam.dps.enums.MieszkaniecInfo;
import pl.topteam.dps.enums.Plec;
import pl.topteam.dps.magazyn.model.Wlasciciel;
import pl.topteam.dps.model.main.Adres;
import pl.topteam.dps.model.main.DecyzjaKierujaca;
import pl.topteam.dps.model.main.DecyzjaWygaszajaca;
import pl.topteam.dps.model.main.DowodOsobisty;
import pl.topteam.dps.model.main.DpsJednostkaPokoj;
import pl.topteam.dps.model.main.EwidencjaDps;
import pl.topteam.dps.model.main.OrzeczONiepelnospraw;
import pl.topteam.dps.model.main.OsobaRodzina;
import pl.topteam.dps.model.main.PostanowienieSadu;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@ListaZmiennychWydruku(id="osoba", zmienne={@ZmiennaWydruku(nazwa="dataUrodzenia", opis="data urodzenia"), @ZmiennaWydruku(nazwa="id", opis="unikalny identyfikator osoby w programie"), @ZmiennaWydruku(nazwa="imie", opis="imi\u0119"), @ZmiennaWydruku(nazwa="imieDrugie", opis="drugie imi\u0119"), @ZmiennaWydruku(nazwa="imieMatki", opis="imi\u0119 matki"), @ZmiennaWydruku(nazwa="imieOjca", opis="imi\u0119 ojca"), @ZmiennaWydruku(nazwa="imieWspolmalzonka", opis="imi\u0119 wsp\u00f3\u0142ma\u0142\u017conka"), @ZmiennaWydruku(nazwa="miejsceUrodzenia", opis="miejsce urodzenia"), @ZmiennaWydruku(nazwa="nazwisko", opis="nazwisko"), @ZmiennaWydruku(nazwa="nazwiskoImie", opis="nazwisko i imi\u0119 razem rozdzielone pojedyncz\u0105 spacj\u0105"), @ZmiennaWydruku(nazwa="nazwiskoRodowe", opis="nazwisko rodowe"), @ZmiennaWydruku(nazwa="nazwiskoRodoweMatki", opis="nazwisko rodowe matki"), @ZmiennaWydruku(nazwa="nazwiskoWspolmalzonka", opis="nazwisko wsp\u00f3\u0142ma\u0142\u017conka"), @ZmiennaWydruku(nazwa="nip", opis="NIP"), @ZmiennaWydruku(nazwa="pesel", opis="PESEL"), @ZmiennaWydruku(nazwa="plec", opis="p\u0142e\u0107 osoby (dodatkowo .nazwa wypisze pe\u0142n\u0105 nazw\u0119 p\u0142ci)"), @ZmiennaWydruku(nazwa="sformatowanyNip", opis="NIP sformatowany wg wzoru 999-999-99-99"), @ZmiennaWydruku(nazwa="stanCywilnyId", opis="unikalny identyfikator stanu cywilnego dost\u0119pnego w s\u0142owniku"), @ZmiennaWydruku(nazwa="telefonKom", opis="numer telefonu kom\u00f3rkowego osoby")})
public class Osoba
extends pl.topteam.dps.model.main_gen.Osoba
implements Wlasciciel {
    private static final long serialVersionUID = -6159746781670225425L;
    @ZmiennaWydrukuPominPole
    private DecyzjaKierujaca decyzjaKierujaca;
    @ZmiennaWydrukuPominPole
    private Adres adres;
    @ZmiennaWydrukuPominPole
    private DowodOsobisty dowodOs;
    @ZmiennaWydrukuPominPole
    private DecyzjaWygaszajaca decyzjaWygaszajaca;
    @ZmiennaWydrukuPominPole
    private EwidencjaDps ewidencjaDps;
    @ZmiennaWydrukuPominPole
    private DpsJednostkaPokoj dpsJednostkaPokoj;
    @ZmiennaWydrukuPominPole
    private OsobaRodzina osobaRodzina;
    @ZmiennaWydrukuPominPole
    private List<OsobaRodzina> historiaOsoby;
    @ZmiennaWydrukuPominPole
    private PostanowienieSadu postanowienieSadu;
    @ZmiennaWydrukuPominPole
    private OrzeczONiepelnospraw orzeczenieNiepelnosprawnosc;
    @ZmiennaWydrukuPominPole
    private Date data;
    @ZmiennaWydrukuPominPole
    private List<MieszkaniecInfo> informacjeOMieszkancu;
    public static final Function<Osoba, Plec> PLEC_OSOBY = new Function<Osoba, Plec>(){

        public Plec apply(Osoba os) {
            return os.getPlec();
        }
    };

    public static final Function<Osoba, Integer> WIEK_OSOBY(final LocalDate naDzien) {
        return new Function<Osoba, Integer>(){

            public Integer apply(Osoba os) {
                LocalDate urodzonaDnia = LocalDate.fromDateFields((Date)os.getDataUrodzenia());
                int wiek = Years.yearsBetween((ReadablePartial)urodzonaDnia, (ReadablePartial)naDzien).getYears();
                return wiek < 0 ? 0 : wiek;
            }
        };
    }

    public String getNazwiskoImie() {
        return (StringUtils.isNotEmpty((CharSequence)this.getNazwisko()) ? this.getNazwisko() : "") + " " + (StringUtils.isNotEmpty((CharSequence)this.getImie()) ? this.getImie() : "");
    }

    public String getSformatowanyNip() {
        String nip = super.getNip();
        if (nip != null && nip.trim().contains(" ") || StringUtils.isEmpty((CharSequence)nip) || nip.length() < 10) {
            return nip;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(nip.substring(0, 3));
        sb.append("-");
        sb.append(nip.substring(3, 6));
        sb.append("-");
        sb.append(nip.substring(6, 8));
        sb.append("-");
        sb.append(nip.substring(8, 10));
        return sb.toString();
    }

    @Override
    public void setNip(String nip) {
        super.setNip(StringUtils.isEmpty((CharSequence)nip) ? null : nip.replaceAll("\\D", ""));
    }

    public EwidencjaDps getEwidencjaDps() {
        return this.ewidencjaDps;
    }

    public void setEwidencjaDps(EwidencjaDps ewidencjaDps) {
        this.ewidencjaDps = ewidencjaDps;
    }

    public DowodOsobisty getDowodOs() {
        return this.dowodOs;
    }

    public void setDowodOs(DowodOsobisty dowodOs) {
        this.dowodOs = dowodOs;
    }

    public Adres getAdres() {
        return this.adres;
    }

    public void setAdres(Adres adres) {
        this.adres = adres;
    }

    public DecyzjaWygaszajaca getDecyzjaWygaszajaca() {
        return this.decyzjaWygaszajaca;
    }

    public void setDecyzjaWygaszajaca(DecyzjaWygaszajaca decyzjaWygaszajaca) {
        this.decyzjaWygaszajaca = decyzjaWygaszajaca;
    }

    public PostanowienieSadu getPostanowienieSadu() {
        return this.postanowienieSadu;
    }

    public void setPostanowienieSadu(PostanowienieSadu postanowienieSadu) {
        this.postanowienieSadu = postanowienieSadu;
    }

    public OrzeczONiepelnospraw getOrzeczenieNiepelnosprawnosc() {
        return this.orzeczenieNiepelnosprawnosc;
    }

    public void setOrzeczenieNiepelnosprawnosc(OrzeczONiepelnospraw orzeczenieNiepelnosprawnosc) {
        this.orzeczenieNiepelnosprawnosc = orzeczenieNiepelnosprawnosc;
    }

    public OsobaRodzina getOsobaRodzina() {
        return this.osobaRodzina;
    }

    public void setOsobaRodzina(OsobaRodzina osobaRodzina) {
        this.osobaRodzina = osobaRodzina;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public List<OsobaRodzina> getHistoriaOsoby() {
        return this.historiaOsoby;
    }

    public void setHistoriaOsoby(List<OsobaRodzina> historiaOsoby) {
        this.historiaOsoby = historiaOsoby;
    }

    public DpsJednostkaPokoj getDpsJednostkaPokoj() {
        return this.dpsJednostkaPokoj;
    }

    public void setDpsJednostkaPokoj(DpsJednostkaPokoj dpsJednostkaPokoj) {
        this.dpsJednostkaPokoj = dpsJednostkaPokoj;
    }

    public List<MieszkaniecInfo> getInformacjeOMieszkancu() {
        return this.informacjeOMieszkancu;
    }

    public void setInformacjeOMieszkancu(List<MieszkaniecInfo> informacjeOMieszkancu) {
        this.informacjeOMieszkancu = informacjeOMieszkancu;
    }

    public DecyzjaKierujaca getDecyzjaKierujaca() {
        return this.decyzjaKierujaca;
    }

    public void setDecyzjaKierujaca(DecyzjaKierujaca decyzjaKierujaca) {
        this.decyzjaKierujaca = decyzjaKierujaca;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("nazwisko", (Object)this.getNazwisko()).add("imie", (Object)this.getImie()).add("data urodzenia", (Object)this.getDataUrodzenia()).add("PESEL", (Object)this.getPesel()).add("plec", (Object)this.getPlec()).toString();
    }
}

