package pl.topteam.dps.dao.main;

import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.Lek;

public interface LekiDorazneMagazynMapper {
	
	/**
	 * Obliczanie liczby rekordów, które zostaną zwrócone gdy
	 * ten sam filtr zostanie podany jako parametr do metody filtrOperacji
	 * 
	 * @param filtr
	 * @return
	 */
	Integer filtrOperacjiIleWierszy(Map<String, Object> filtr);
	
	/**
	 * Filtr operacji w magazynie.
	 * 
	 * @param filtr
	 * @return
	 */
	List<Map<String, ?>> filtrOperacji(Map<String, Object> filtr);

	/**
	 * Obliczanie liczby rekordów, które zostaną zwrócone gdy
	 * ten sam filtr zostanie podany jako parametr do metody filtrLekow.
	 * 
	 * @param filtr
	 * @return
	 */
	Integer filtrLekowIleWierszy(Map<String, Object> filtr);
	
	/**
	 * Filtr leków w magazynie.
	 * 
	 * @param filtr
	 * @return
	 */
	List<Lek> filtrLekow(Map<String, Object> filtr);
}
