package pl.topteam.dps.dao.main;

import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.OsobaPracownik;
import pl.topteam.dps.model.main.Pracownik;

public interface OsobaPracownikMapper extends pl.topteam.dps.dao.main_gen.OsobaPracownikMapper {

	/**
	 * Filtr wszystkich przypisan osób do pracowników
	 * @param filtr
	 * @return
	 */
	List<OsobaPracownik> filtrPrzypisanHistoria(Map<String, Object> filtr);
	
	/**
	 * Filtr tylko aktualnych przypisań (historyczne nie wchodzą do wyniku)
	 * 
	 * @param filtr
	 * @return
	 */
	List<OsobaPracownik> filtrAktualnychPrzypisan(Map<String, Object> filtr);
	
	/**
	 * Zwraca listę aktualnie przypisanych pracowników do wskazanej osoby
	 * 
	 * @param idOsoby
	 * @return
	 */
	List<Pracownik> selectAktualnePrzypPracDlaMieszkanca(Map<String, Object> filtr);
}
