package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.DawkaPodanie;
import pl.topteam.dps.model.main.DawkaPodanieCriteria;
import pl.topteam.dps.model.main_gen.DawkaPodanieKey;

public abstract interface DawkaPodanieMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=DawkaPodanieSqlProvider.class, method="countByExample")
    int countByExample(DawkaPodanieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=DawkaPodanieSqlProvider.class, method="deleteByExample")
    int deleteByExample(DawkaPodanieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from DAWKA_PODANIE",
        "where DAWKOWANIE_ID = #{dawkowanieId,jdbcType=BIGINT}",
          "and LEK_ID = #{lekId,jdbcType=BIGINT}",
          "and PORA_ID = #{poraId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(DawkaPodanieKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into DAWKA_PODANIE (DAWKOWANIE_ID, LEK_ID, ",
        "PORA_ID, DATA, DAWKA)",
        "values (#{dawkowanieId,jdbcType=BIGINT}, #{lekId,jdbcType=BIGINT}, ",
        "#{poraId,jdbcType=BIGINT}, #{data,jdbcType=DATE}, #{dawka,jdbcType=DECIMAL})"
    })
    int insert(DawkaPodanie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(DawkaPodanie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=DawkaPodanieSqlProvider.class, method="insertSelective")
    int insertSelective(DawkaPodanie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=DawkaPodanieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DAWKOWANIE_ID", property="dawkowanieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_ID", property="poraId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.DECIMAL)
    })
    List<DawkaPodanie> selectByExampleWithRowbounds(DawkaPodanieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=DawkaPodanieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DAWKOWANIE_ID", property="dawkowanieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_ID", property="poraId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.DECIMAL)
    })
    List<DawkaPodanie> selectByExample(DawkaPodanieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "DAWKOWANIE_ID, LEK_ID, PORA_ID, DATA, DAWKA",
        "from DAWKA_PODANIE",
        "where DAWKOWANIE_ID = #{dawkowanieId,jdbcType=BIGINT}",
          "and LEK_ID = #{lekId,jdbcType=BIGINT}",
          "and PORA_ID = #{poraId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="DAWKOWANIE_ID", property="dawkowanieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_ID", property="poraId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.DECIMAL)
    })
    DawkaPodanie selectByPrimaryKey(DawkaPodanieKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=DawkaPodanieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") DawkaPodanie record, @Param("example") DawkaPodanieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=DawkaPodanieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") DawkaPodanie record, @Param("example") DawkaPodanieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=DawkaPodanieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(DawkaPodanie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update DAWKA_PODANIE",
        "set DATA = #{data,jdbcType=DATE},",
          "DAWKA = #{dawka,jdbcType=DECIMAL}",
        "where DAWKOWANIE_ID = #{dawkowanieId,jdbcType=BIGINT}",
          "and LEK_ID = #{lekId,jdbcType=BIGINT}",
          "and PORA_ID = #{poraId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(DawkaPodanie record);
}