package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.DiagnozaRealizacja;
import pl.topteam.dps.model.main.DiagnozaRealizacjaCriteria;

public abstract interface DiagnozaRealizacjaMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=DiagnozaRealizacjaSqlProvider.class, method="countByExample")
    int countByExample(DiagnozaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=DiagnozaRealizacjaSqlProvider.class, method="deleteByExample")
    int deleteByExample(DiagnozaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from DIAGNOZA_REALIZACJA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into DIAGNOZA_REALIZACJA (DIAGNOZA_ID, EWIDENCJA_DPS_ID, ",
        "PRACOWNIK_WYKONAL_ID, CZY_WSTEPNA, ",
        "DATA, STATUS)",
        "values (#{diagnozaId,jdbcType=BIGINT}, #{ewidencjaDpsId,jdbcType=BIGINT}, ",
        "#{pracownikWykonalId,jdbcType=BIGINT}, #{czyWstepna,jdbcType=BOOLEAN}, ",
        "#{data,jdbcType=DATE}, #{status,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(DiagnozaRealizacja record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(DiagnozaRealizacja record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=DiagnozaRealizacjaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(DiagnozaRealizacja record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=DiagnozaRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DIAGNOZA_ID", property="diagnozaId", jdbcType=JdbcType.BIGINT),
        @Result(column="EWIDENCJA_DPS_ID", property="ewidencjaDpsId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_WYKONAL_ID", property="pracownikWykonalId", jdbcType=JdbcType.BIGINT),
        @Result(column="CZY_WSTEPNA", property="czyWstepna", jdbcType=JdbcType.BOOLEAN),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR)
    })
    List<DiagnozaRealizacja> selectByExampleWithRowbounds(DiagnozaRealizacjaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=DiagnozaRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DIAGNOZA_ID", property="diagnozaId", jdbcType=JdbcType.BIGINT),
        @Result(column="EWIDENCJA_DPS_ID", property="ewidencjaDpsId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_WYKONAL_ID", property="pracownikWykonalId", jdbcType=JdbcType.BIGINT),
        @Result(column="CZY_WSTEPNA", property="czyWstepna", jdbcType=JdbcType.BOOLEAN),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR)
    })
    List<DiagnozaRealizacja> selectByExample(DiagnozaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ID, DIAGNOZA_ID, EWIDENCJA_DPS_ID, PRACOWNIK_WYKONAL_ID, CZY_WSTEPNA, DATA, ",
        "STATUS",
        "from DIAGNOZA_REALIZACJA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DIAGNOZA_ID", property="diagnozaId", jdbcType=JdbcType.BIGINT),
        @Result(column="EWIDENCJA_DPS_ID", property="ewidencjaDpsId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_WYKONAL_ID", property="pracownikWykonalId", jdbcType=JdbcType.BIGINT),
        @Result(column="CZY_WSTEPNA", property="czyWstepna", jdbcType=JdbcType.BOOLEAN),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR)
    })
    DiagnozaRealizacja selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=DiagnozaRealizacjaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") DiagnozaRealizacja record, @Param("example") DiagnozaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=DiagnozaRealizacjaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") DiagnozaRealizacja record, @Param("example") DiagnozaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=DiagnozaRealizacjaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(DiagnozaRealizacja record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update DIAGNOZA_REALIZACJA",
        "set DIAGNOZA_ID = #{diagnozaId,jdbcType=BIGINT},",
          "EWIDENCJA_DPS_ID = #{ewidencjaDpsId,jdbcType=BIGINT},",
          "PRACOWNIK_WYKONAL_ID = #{pracownikWykonalId,jdbcType=BIGINT},",
          "CZY_WSTEPNA = #{czyWstepna,jdbcType=BOOLEAN},",
          "DATA = #{data,jdbcType=DATE},",
          "STATUS = #{status,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(DiagnozaRealizacja record);
}