package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.DpsJednostkaProfil;
import pl.topteam.dps.model.main_gen.DpsJednostkaProfilCriteria.Criteria;
import pl.topteam.dps.model.main_gen.DpsJednostkaProfilCriteria.Criterion;
import pl.topteam.dps.model.main.DpsJednostkaProfilCriteria;

public class DpsJednostkaProfilSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(DpsJednostkaProfilCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("DPS_JEDNOSTKA_PROFIL");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(DpsJednostkaProfilCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("DPS_JEDNOSTKA_PROFIL");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(DpsJednostkaProfil record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("DPS_JEDNOSTKA_PROFIL");
        
        if (record.getNumer() != null) {
            sql.VALUES("NUMER", "#{numer,jdbcType=VARCHAR}");
        }
        
        if (record.getDpsJednostkaId() != null) {
            sql.VALUES("DPS_JEDNOSTKA_ID", "#{dpsJednostkaId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzaj() != null) {
            sql.VALUES("RODZAJ", "#{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaMiejsc() != null) {
            sql.VALUES("LICZBA_MIEJSC", "#{liczbaMiejsc,jdbcType=INTEGER}");
        }
        
        if (record.getLiczbaMiejscK() != null) {
            sql.VALUES("LICZBA_MIEJSC_K", "#{liczbaMiejscK,jdbcType=INTEGER}");
        }
        
        if (record.getLiczbaMiejscM() != null) {
            sql.VALUES("LICZBA_MIEJSC_M", "#{liczbaMiejscM,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(DpsJednostkaProfilCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("NUMER");
        } else {
            sql.SELECT("NUMER");
        }
        sql.SELECT("DPS_JEDNOSTKA_ID");
        sql.SELECT("RODZAJ");
        sql.SELECT("LICZBA_MIEJSC");
        sql.SELECT("LICZBA_MIEJSC_K");
        sql.SELECT("LICZBA_MIEJSC_M");
        sql.FROM("DPS_JEDNOSTKA_PROFIL");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        DpsJednostkaProfil record = (DpsJednostkaProfil) parameter.get("record");
        DpsJednostkaProfilCriteria example = (DpsJednostkaProfilCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("DPS_JEDNOSTKA_PROFIL");
        
        if (record.getNumer() != null) {
            sql.SET("NUMER = #{record.numer,jdbcType=VARCHAR}");
        }
        
        if (record.getDpsJednostkaId() != null) {
            sql.SET("DPS_JEDNOSTKA_ID = #{record.dpsJednostkaId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaMiejsc() != null) {
            sql.SET("LICZBA_MIEJSC = #{record.liczbaMiejsc,jdbcType=INTEGER}");
        }
        
        if (record.getLiczbaMiejscK() != null) {
            sql.SET("LICZBA_MIEJSC_K = #{record.liczbaMiejscK,jdbcType=INTEGER}");
        }
        
        if (record.getLiczbaMiejscM() != null) {
            sql.SET("LICZBA_MIEJSC_M = #{record.liczbaMiejscM,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("DPS_JEDNOSTKA_PROFIL");
        
        sql.SET("NUMER = #{record.numer,jdbcType=VARCHAR}");
        sql.SET("DPS_JEDNOSTKA_ID = #{record.dpsJednostkaId,jdbcType=BIGINT}");
        sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        sql.SET("LICZBA_MIEJSC = #{record.liczbaMiejsc,jdbcType=INTEGER}");
        sql.SET("LICZBA_MIEJSC_K = #{record.liczbaMiejscK,jdbcType=INTEGER}");
        sql.SET("LICZBA_MIEJSC_M = #{record.liczbaMiejscM,jdbcType=INTEGER}");
        
        DpsJednostkaProfilCriteria example = (DpsJednostkaProfilCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(DpsJednostkaProfil record) {
        SQL sql = new SQL();
        sql.UPDATE("DPS_JEDNOSTKA_PROFIL");
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaMiejsc() != null) {
            sql.SET("LICZBA_MIEJSC = #{liczbaMiejsc,jdbcType=INTEGER}");
        }
        
        if (record.getLiczbaMiejscK() != null) {
            sql.SET("LICZBA_MIEJSC_K = #{liczbaMiejscK,jdbcType=INTEGER}");
        }
        
        if (record.getLiczbaMiejscM() != null) {
            sql.SET("LICZBA_MIEJSC_M = #{liczbaMiejscM,jdbcType=INTEGER}");
        }
        
        sql.WHERE("NUMER = #{numer,jdbcType=VARCHAR}");
        sql.WHERE("DPS_JEDNOSTKA_ID = #{dpsJednostkaId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, DpsJednostkaProfilCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}