package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Dziennik;
import pl.topteam.dps.model.main.DziennikCriteria;

public abstract interface DziennikMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    @SelectProvider(type=DziennikSqlProvider.class, method="countByExample")
    int countByExample(DziennikCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    @Insert({
        "insert into DZIENNIK (PRACOWNIK_ID, DATA, ",
        "OBIEKT_ID, TYP_OPERACJI)",
        "values (#{pracownikId,jdbcType=BIGINT}, #{data,jdbcType=TIMESTAMP}, ",
        "#{obiektId,jdbcType=BIGINT}, #{typOperacji,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Dziennik record);

    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    int mergeInto(Dziennik record);

    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    @InsertProvider(type=DziennikSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Dziennik record);

    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    @SelectProvider(type=DziennikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA", property="data", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="OBIEKT_ID", property="obiektId", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP_OPERACJI", property="typOperacji", jdbcType=JdbcType.VARCHAR)
    })
    List<Dziennik> selectByExampleWithRowbounds(DziennikCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    @SelectProvider(type=DziennikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA", property="data", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="OBIEKT_ID", property="obiektId", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP_OPERACJI", property="typOperacji", jdbcType=JdbcType.VARCHAR)
    })
    List<Dziennik> selectByExample(DziennikCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:58
     */
    @Select({
        "select",
        "ID, PRACOWNIK_ID, DATA, OBIEKT_ID, TYP_OPERACJI",
        "from DZIENNIK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA", property="data", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="OBIEKT_ID", property="obiektId", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP_OPERACJI", property="typOperacji", jdbcType=JdbcType.VARCHAR)
    })
    Dziennik selectByPrimaryKey(Long id);
}