package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.EwidencjaPokoje;
import pl.topteam.dps.model.main_gen.EwidencjaPokojeCriteria.Criteria;
import pl.topteam.dps.model.main_gen.EwidencjaPokojeCriteria.Criterion;
import pl.topteam.dps.model.main.EwidencjaPokojeCriteria;

public class EwidencjaPokojeSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(EwidencjaPokojeCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("EWIDENCJA_POKOJE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(EwidencjaPokojeCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("EWIDENCJA_POKOJE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(EwidencjaPokoje record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("EWIDENCJA_POKOJE");
        
        if (record.getDpsPokojId() != null) {
            sql.VALUES("DPS_POKOJ_ID", "#{dpsPokojId,jdbcType=BIGINT}");
        }
        
        if (record.getEwidencjaDpsId() != null) {
            sql.VALUES("EWIDENCJA_DPS_ID", "#{ewidencjaDpsId,jdbcType=BIGINT}");
        }
        
        if (record.getPoprzedniPokojId() != null) {
            sql.VALUES("POPRZEDNI_POKOJ_ID", "#{poprzedniPokojId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(EwidencjaPokojeCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("DPS_POKOJ_ID");
        sql.SELECT("EWIDENCJA_DPS_ID");
        sql.SELECT("POPRZEDNI_POKOJ_ID");
        sql.SELECT("DATA_OD");
        sql.FROM("EWIDENCJA_POKOJE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        EwidencjaPokoje record = (EwidencjaPokoje) parameter.get("record");
        EwidencjaPokojeCriteria example = (EwidencjaPokojeCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("EWIDENCJA_POKOJE");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getDpsPokojId() != null) {
            sql.SET("DPS_POKOJ_ID = #{record.dpsPokojId,jdbcType=BIGINT}");
        }
        
        if (record.getEwidencjaDpsId() != null) {
            sql.SET("EWIDENCJA_DPS_ID = #{record.ewidencjaDpsId,jdbcType=BIGINT}");
        }
        
        if (record.getPoprzedniPokojId() != null) {
            sql.SET("POPRZEDNI_POKOJ_ID = #{record.poprzedniPokojId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("EWIDENCJA_POKOJE");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("DPS_POKOJ_ID = #{record.dpsPokojId,jdbcType=BIGINT}");
        sql.SET("EWIDENCJA_DPS_ID = #{record.ewidencjaDpsId,jdbcType=BIGINT}");
        sql.SET("POPRZEDNI_POKOJ_ID = #{record.poprzedniPokojId,jdbcType=BIGINT}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        
        EwidencjaPokojeCriteria example = (EwidencjaPokojeCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(EwidencjaPokoje record) {
        SQL sql = new SQL();
        sql.UPDATE("EWIDENCJA_POKOJE");
        
        if (record.getDpsPokojId() != null) {
            sql.SET("DPS_POKOJ_ID = #{dpsPokojId,jdbcType=BIGINT}");
        }
        
        if (record.getEwidencjaDpsId() != null) {
            sql.SET("EWIDENCJA_DPS_ID = #{ewidencjaDpsId,jdbcType=BIGINT}");
        }
        
        if (record.getPoprzedniPokojId() != null) {
            sql.SET("POPRZEDNI_POKOJ_ID = #{poprzedniPokojId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, EwidencjaPokojeCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}