package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.InformacjaDodatkowaPole;
import pl.topteam.dps.model.main_gen.InformacjaDodatkowaPoleCriteria.Criteria;
import pl.topteam.dps.model.main_gen.InformacjaDodatkowaPoleCriteria.Criterion;
import pl.topteam.dps.model.main.InformacjaDodatkowaPoleCriteria;

public class InformacjaDodatkowaPoleSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(InformacjaDodatkowaPoleCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("INFORMACJA_DODATKOWA_POLE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(InformacjaDodatkowaPoleCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("INFORMACJA_DODATKOWA_POLE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(InformacjaDodatkowaPole record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("INFORMACJA_DODATKOWA_POLE");
        
        if (record.getInformacjaDodatkowaId() != null) {
            sql.VALUES("INFORMACJA_DODATKOWA_ID", "#{informacjaDodatkowaId,jdbcType=BIGINT}");
        }
        
        if (record.getJednostkaMiary() != null) {
            sql.VALUES("JEDNOSTKA_MIARY", "#{jednostkaMiary,jdbcType=VARCHAR}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.VALUES("KOLEJNOSC", "#{kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwaSlownika() != null) {
            sql.VALUES("NAZWA_SLOWNIKA", "#{nazwaSlownika,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzaj() != null) {
            sql.VALUES("RODZAJ", "#{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            sql.VALUES("TYP", "#{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getWymagane() != null) {
            sql.VALUES("WYMAGANE", "#{wymagane,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(InformacjaDodatkowaPoleCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("INFORMACJA_DODATKOWA_ID");
        sql.SELECT("JEDNOSTKA_MIARY");
        sql.SELECT("KOLEJNOSC");
        sql.SELECT("NAZWA");
        sql.SELECT("NAZWA_SLOWNIKA");
        sql.SELECT("RODZAJ");
        sql.SELECT("TYP");
        sql.SELECT("WYMAGANE");
        sql.FROM("INFORMACJA_DODATKOWA_POLE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        InformacjaDodatkowaPole record = (InformacjaDodatkowaPole) parameter.get("record");
        InformacjaDodatkowaPoleCriteria example = (InformacjaDodatkowaPoleCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("INFORMACJA_DODATKOWA_POLE");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getInformacjaDodatkowaId() != null) {
            sql.SET("INFORMACJA_DODATKOWA_ID = #{record.informacjaDodatkowaId,jdbcType=BIGINT}");
        }
        
        if (record.getJednostkaMiary() != null) {
            sql.SET("JEDNOSTKA_MIARY = #{record.jednostkaMiary,jdbcType=VARCHAR}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwaSlownika() != null) {
            sql.SET("NAZWA_SLOWNIKA = #{record.nazwaSlownika,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            sql.SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        }
        
        if (record.getWymagane() != null) {
            sql.SET("WYMAGANE = #{record.wymagane,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("INFORMACJA_DODATKOWA_POLE");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("INFORMACJA_DODATKOWA_ID = #{record.informacjaDodatkowaId,jdbcType=BIGINT}");
        sql.SET("JEDNOSTKA_MIARY = #{record.jednostkaMiary,jdbcType=VARCHAR}");
        sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        sql.SET("NAZWA_SLOWNIKA = #{record.nazwaSlownika,jdbcType=VARCHAR}");
        sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        sql.SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        sql.SET("WYMAGANE = #{record.wymagane,jdbcType=BOOLEAN}");
        
        InformacjaDodatkowaPoleCriteria example = (InformacjaDodatkowaPoleCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(InformacjaDodatkowaPole record) {
        SQL sql = new SQL();
        sql.UPDATE("INFORMACJA_DODATKOWA_POLE");
        
        if (record.getInformacjaDodatkowaId() != null) {
            sql.SET("INFORMACJA_DODATKOWA_ID = #{informacjaDodatkowaId,jdbcType=BIGINT}");
        }
        
        if (record.getJednostkaMiary() != null) {
            sql.SET("JEDNOSTKA_MIARY = #{jednostkaMiary,jdbcType=VARCHAR}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwaSlownika() != null) {
            sql.SET("NAZWA_SLOWNIKA = #{nazwaSlownika,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            sql.SET("TYP = #{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getWymagane() != null) {
            sql.SET("WYMAGANE = #{wymagane,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, InformacjaDodatkowaPoleCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}