package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Lek;
import pl.topteam.dps.model.main.LekCriteria;

public abstract interface LekMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=LekSqlProvider.class, method="countByExample")
    int countByExample(LekCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=LekSqlProvider.class, method="deleteByExample")
    int deleteByExample(LekCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from LEK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into LEK (DAWKA, NAZWA, ",
        "OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC)",
        "values (#{dawka,jdbcType=VARCHAR}, #{nazwa,jdbcType=VARCHAR}, ",
        "#{opakowanieJednostkaPojemnosci,jdbcType=VARCHAR}, #{postac,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Lek record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(Lek record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=LekSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Lek record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=LekSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPAKOWANIE_JEDNOSTKA_POJEMNOSCI", property="opakowanieJednostkaPojemnosci", jdbcType=JdbcType.VARCHAR),
        @Result(column="POSTAC", property="postac", jdbcType=JdbcType.VARCHAR)
    })
    List<Lek> selectByExampleWithRowbounds(LekCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=LekSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPAKOWANIE_JEDNOSTKA_POJEMNOSCI", property="opakowanieJednostkaPojemnosci", jdbcType=JdbcType.VARCHAR),
        @Result(column="POSTAC", property="postac", jdbcType=JdbcType.VARCHAR)
    })
    List<Lek> selectByExample(LekCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ID, DAWKA, NAZWA, OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC",
        "from LEK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPAKOWANIE_JEDNOSTKA_POJEMNOSCI", property="opakowanieJednostkaPojemnosci", jdbcType=JdbcType.VARCHAR),
        @Result(column="POSTAC", property="postac", jdbcType=JdbcType.VARCHAR)
    })
    Lek selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=LekSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Lek record, @Param("example") LekCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=LekSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Lek record, @Param("example") LekCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=LekSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Lek record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update LEK",
        "set DAWKA = #{dawka,jdbcType=VARCHAR},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR},",
          "OPAKOWANIE_JEDNOSTKA_POJEMNOSCI = #{opakowanieJednostkaPojemnosci,jdbcType=VARCHAR},",
          "POSTAC = #{postac,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Lek record);
}