package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.LekRealizacja;
import pl.topteam.dps.model.main_gen.LekRealizacjaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.LekRealizacjaCriteria.Criterion;
import pl.topteam.dps.model.main.LekRealizacjaCriteria;

public class LekRealizacjaSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(LekRealizacjaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("LEK_REALIZACJA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(LekRealizacjaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("LEK_REALIZACJA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(LekRealizacja record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("LEK_REALIZACJA");
        
        if (record.getRealizacjaReceptaId() != null) {
            sql.VALUES("REALIZACJA_RECEPTA_ID", "#{realizacjaReceptaId,jdbcType=BIGINT}");
        }
        
        if (record.getKodBazyl() != null) {
            sql.VALUES("KOD_BAZYL", "#{kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getNiezrealizowany() != null) {
            sql.VALUES("NIEZREALIZOWANY", "#{niezrealizowany,jdbcType=BOOLEAN}");
        }
        
        if (record.getSlowoId() != null) {
            sql.VALUES("SLOWO_ID", "#{slowoId,jdbcType=BIGINT}");
        }
        
        if (record.getLiczbaOpakowan() != null) {
            sql.VALUES("LICZBA_OPAKOWAN", "#{liczbaOpakowan,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            sql.VALUES("DATA", "#{data,jdbcType=DATE}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(LekRealizacjaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("REALIZACJA_RECEPTA_ID");
        } else {
            sql.SELECT("REALIZACJA_RECEPTA_ID");
        }
        sql.SELECT("KOD_BAZYL");
        sql.SELECT("NIEZREALIZOWANY");
        sql.SELECT("SLOWO_ID");
        sql.SELECT("LICZBA_OPAKOWAN");
        sql.SELECT("DATA");
        sql.FROM("LEK_REALIZACJA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        LekRealizacja record = (LekRealizacja) parameter.get("record");
        LekRealizacjaCriteria example = (LekRealizacjaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("LEK_REALIZACJA");
        
        if (record.getRealizacjaReceptaId() != null) {
            sql.SET("REALIZACJA_RECEPTA_ID = #{record.realizacjaReceptaId,jdbcType=BIGINT}");
        }
        
        if (record.getKodBazyl() != null) {
            sql.SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getNiezrealizowany() != null) {
            sql.SET("NIEZREALIZOWANY = #{record.niezrealizowany,jdbcType=BOOLEAN}");
        }
        
        if (record.getSlowoId() != null) {
            sql.SET("SLOWO_ID = #{record.slowoId,jdbcType=BIGINT}");
        }
        
        if (record.getLiczbaOpakowan() != null) {
            sql.SET("LICZBA_OPAKOWAN = #{record.liczbaOpakowan,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            sql.SET("DATA = #{record.data,jdbcType=DATE}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("LEK_REALIZACJA");
        
        sql.SET("REALIZACJA_RECEPTA_ID = #{record.realizacjaReceptaId,jdbcType=BIGINT}");
        sql.SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        sql.SET("NIEZREALIZOWANY = #{record.niezrealizowany,jdbcType=BOOLEAN}");
        sql.SET("SLOWO_ID = #{record.slowoId,jdbcType=BIGINT}");
        sql.SET("LICZBA_OPAKOWAN = #{record.liczbaOpakowan,jdbcType=INTEGER}");
        sql.SET("DATA = #{record.data,jdbcType=DATE}");
        
        LekRealizacjaCriteria example = (LekRealizacjaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(LekRealizacja record) {
        SQL sql = new SQL();
        sql.UPDATE("LEK_REALIZACJA");
        
        if (record.getSlowoId() != null) {
            sql.SET("SLOWO_ID = #{slowoId,jdbcType=BIGINT}");
        }
        
        if (record.getLiczbaOpakowan() != null) {
            sql.SET("LICZBA_OPAKOWAN = #{liczbaOpakowan,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            sql.SET("DATA = #{data,jdbcType=DATE}");
        }
        
        sql.WHERE("REALIZACJA_RECEPTA_ID = #{realizacjaReceptaId,jdbcType=BIGINT}");
        sql.WHERE("KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}");
        sql.WHERE("NIEZREALIZOWANY = #{niezrealizowany,jdbcType=BOOLEAN}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, LekRealizacjaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}