package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.OsobaRodzina;
import pl.topteam.dps.model.main.OsobaRodzinaCriteria;

public abstract interface OsobaRodzinaMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=OsobaRodzinaSqlProvider.class, method="countByExample")
    int countByExample(OsobaRodzinaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=OsobaRodzinaSqlProvider.class, method="deleteByExample")
    int deleteByExample(OsobaRodzinaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from OSOBA_RODZINA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into OSOBA_RODZINA (OSOBA_ID, RODZINA_ID, ",
        "DATA_OD, DATA_DO, KOD_STOPNIA_POKREWIENSTWA, ",
        "TYP, ZOBOWIAZANY_ALIMENTACJA, ",
        "ZWOLNIONY_ALIMENTACJA)",
        "values (#{osobaId,jdbcType=BIGINT}, #{rodzinaId,jdbcType=BIGINT}, ",
        "#{dataOd,jdbcType=DATE}, #{dataDo,jdbcType=DATE}, #{kodStopniaPokrewienstwa,jdbcType=VARCHAR}, ",
        "#{typ,jdbcType=VARCHAR}, #{zobowiazanyAlimentacja,jdbcType=BOOLEAN}, ",
        "#{zwolnionyAlimentacja,jdbcType=BOOLEAN})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(OsobaRodzina record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(OsobaRodzina record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=OsobaRodzinaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(OsobaRodzina record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=OsobaRodzinaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="RODZINA_ID", property="rodzinaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="KOD_STOPNIA_POKREWIENSTWA", property="kodStopniaPokrewienstwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZOBOWIAZANY_ALIMENTACJA", property="zobowiazanyAlimentacja", jdbcType=JdbcType.BOOLEAN),
        @Result(column="ZWOLNIONY_ALIMENTACJA", property="zwolnionyAlimentacja", jdbcType=JdbcType.BOOLEAN)
    })
    List<OsobaRodzina> selectByExampleWithRowbounds(OsobaRodzinaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=OsobaRodzinaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="RODZINA_ID", property="rodzinaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="KOD_STOPNIA_POKREWIENSTWA", property="kodStopniaPokrewienstwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZOBOWIAZANY_ALIMENTACJA", property="zobowiazanyAlimentacja", jdbcType=JdbcType.BOOLEAN),
        @Result(column="ZWOLNIONY_ALIMENTACJA", property="zwolnionyAlimentacja", jdbcType=JdbcType.BOOLEAN)
    })
    List<OsobaRodzina> selectByExample(OsobaRodzinaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ID, OSOBA_ID, RODZINA_ID, DATA_OD, DATA_DO, KOD_STOPNIA_POKREWIENSTWA, TYP, ",
        "ZOBOWIAZANY_ALIMENTACJA, ZWOLNIONY_ALIMENTACJA",
        "from OSOBA_RODZINA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="RODZINA_ID", property="rodzinaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="KOD_STOPNIA_POKREWIENSTWA", property="kodStopniaPokrewienstwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZOBOWIAZANY_ALIMENTACJA", property="zobowiazanyAlimentacja", jdbcType=JdbcType.BOOLEAN),
        @Result(column="ZWOLNIONY_ALIMENTACJA", property="zwolnionyAlimentacja", jdbcType=JdbcType.BOOLEAN)
    })
    OsobaRodzina selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=OsobaRodzinaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") OsobaRodzina record, @Param("example") OsobaRodzinaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=OsobaRodzinaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") OsobaRodzina record, @Param("example") OsobaRodzinaCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=OsobaRodzinaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(OsobaRodzina record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update OSOBA_RODZINA",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "RODZINA_ID = #{rodzinaId,jdbcType=BIGINT},",
          "DATA_OD = #{dataOd,jdbcType=DATE},",
          "DATA_DO = #{dataDo,jdbcType=DATE},",
          "KOD_STOPNIA_POKREWIENSTWA = #{kodStopniaPokrewienstwa,jdbcType=VARCHAR},",
          "TYP = #{typ,jdbcType=VARCHAR},",
          "ZOBOWIAZANY_ALIMENTACJA = #{zobowiazanyAlimentacja,jdbcType=BOOLEAN},",
          "ZWOLNIONY_ALIMENTACJA = #{zwolnionyAlimentacja,jdbcType=BOOLEAN}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(OsobaRodzina record);
}