package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.Osoba;
import pl.topteam.dps.model.main_gen.OsobaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.OsobaCriteria.Criterion;
import pl.topteam.dps.model.main.OsobaCriteria;

public class OsobaSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(OsobaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("OSOBA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(OsobaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("OSOBA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(Osoba record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("OSOBA");
        
        if (record.getStanCywilnyId() != null) {
            sql.VALUES("STAN_CYWILNY_ID", "#{stanCywilnyId,jdbcType=BIGINT}");
        }
        
        if (record.getDataUrodzenia() != null) {
            sql.VALUES("DATA_URODZENIA", "#{dataUrodzenia,jdbcType=DATE}");
        }
        
        if (record.getImie() != null) {
            sql.VALUES("IMIE", "#{imie,jdbcType=VARCHAR}");
        }
        
        if (record.getImieDrugie() != null) {
            sql.VALUES("IMIE_DRUGIE", "#{imieDrugie,jdbcType=VARCHAR}");
        }
        
        if (record.getImieMatki() != null) {
            sql.VALUES("IMIE_MATKI", "#{imieMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getImieOjca() != null) {
            sql.VALUES("IMIE_OJCA", "#{imieOjca,jdbcType=VARCHAR}");
        }
        
        if (record.getImieWspolmalzonka() != null) {
            sql.VALUES("IMIE_WSPOLMALZONKA", "#{imieWspolmalzonka,jdbcType=VARCHAR}");
        }
        
        if (record.getImportProgram() != null) {
            sql.VALUES("IMPORT_PROGRAM", "#{importProgram,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejsceUrodzenia() != null) {
            sql.VALUES("MIEJSCE_URODZENIA", "#{miejsceUrodzenia,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwisko() != null) {
            sql.VALUES("NAZWISKO", "#{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoRodowe() != null) {
            sql.VALUES("NAZWISKO_RODOWE", "#{nazwiskoRodowe,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoRodoweMatki() != null) {
            sql.VALUES("NAZWISKO_RODOWE_MATKI", "#{nazwiskoRodoweMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoWspolmalzonka() != null) {
            sql.VALUES("NAZWISKO_WSPOLMALZONKA", "#{nazwiskoWspolmalzonka,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            sql.VALUES("NIP", "#{nip,jdbcType=VARCHAR}");
        }
        
        if (record.getPesel() != null) {
            sql.VALUES("PESEL", "#{pesel,jdbcType=VARCHAR}");
        }
        
        if (record.getPlec() != null) {
            sql.VALUES("PLEC", "#{plec,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefonKom() != null) {
            sql.VALUES("TELEFON_KOM", "#{telefonKom,jdbcType=VARCHAR}");
        }
        
        if (record.getWyznanieId() != null) {
            sql.VALUES("WYZNANIE_ID", "#{wyznanieId,jdbcType=BIGINT}");
        }
        
        if (record.getWyksztalcenieId() != null) {
            sql.VALUES("WYKSZTALCENIE_ID", "#{wyksztalcenieId,jdbcType=BIGINT}");
        }
        
        if (record.getDataZgonu() != null) {
            sql.VALUES("DATA_ZGONU", "#{dataZgonu,jdbcType=DATE}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(OsobaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("STAN_CYWILNY_ID");
        sql.SELECT("DATA_URODZENIA");
        sql.SELECT("IMIE");
        sql.SELECT("IMIE_DRUGIE");
        sql.SELECT("IMIE_MATKI");
        sql.SELECT("IMIE_OJCA");
        sql.SELECT("IMIE_WSPOLMALZONKA");
        sql.SELECT("IMPORT_PROGRAM");
        sql.SELECT("MIEJSCE_URODZENIA");
        sql.SELECT("NAZWISKO");
        sql.SELECT("NAZWISKO_RODOWE");
        sql.SELECT("NAZWISKO_RODOWE_MATKI");
        sql.SELECT("NAZWISKO_WSPOLMALZONKA");
        sql.SELECT("NIP");
        sql.SELECT("PESEL");
        sql.SELECT("PLEC");
        sql.SELECT("TELEFON_KOM");
        sql.SELECT("WYZNANIE_ID");
        sql.SELECT("WYKSZTALCENIE_ID");
        sql.SELECT("DATA_ZGONU");
        sql.FROM("OSOBA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Osoba record = (Osoba) parameter.get("record");
        OsobaCriteria example = (OsobaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("OSOBA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getStanCywilnyId() != null) {
            sql.SET("STAN_CYWILNY_ID = #{record.stanCywilnyId,jdbcType=BIGINT}");
        }
        
        if (record.getDataUrodzenia() != null) {
            sql.SET("DATA_URODZENIA = #{record.dataUrodzenia,jdbcType=DATE}");
        }
        
        if (record.getImie() != null) {
            sql.SET("IMIE = #{record.imie,jdbcType=VARCHAR}");
        }
        
        if (record.getImieDrugie() != null) {
            sql.SET("IMIE_DRUGIE = #{record.imieDrugie,jdbcType=VARCHAR}");
        }
        
        if (record.getImieMatki() != null) {
            sql.SET("IMIE_MATKI = #{record.imieMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getImieOjca() != null) {
            sql.SET("IMIE_OJCA = #{record.imieOjca,jdbcType=VARCHAR}");
        }
        
        if (record.getImieWspolmalzonka() != null) {
            sql.SET("IMIE_WSPOLMALZONKA = #{record.imieWspolmalzonka,jdbcType=VARCHAR}");
        }
        
        if (record.getImportProgram() != null) {
            sql.SET("IMPORT_PROGRAM = #{record.importProgram,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejsceUrodzenia() != null) {
            sql.SET("MIEJSCE_URODZENIA = #{record.miejsceUrodzenia,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwisko() != null) {
            sql.SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoRodowe() != null) {
            sql.SET("NAZWISKO_RODOWE = #{record.nazwiskoRodowe,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoRodoweMatki() != null) {
            sql.SET("NAZWISKO_RODOWE_MATKI = #{record.nazwiskoRodoweMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoWspolmalzonka() != null) {
            sql.SET("NAZWISKO_WSPOLMALZONKA = #{record.nazwiskoWspolmalzonka,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            sql.SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        }
        
        if (record.getPesel() != null) {
            sql.SET("PESEL = #{record.pesel,jdbcType=VARCHAR}");
        }
        
        if (record.getPlec() != null) {
            sql.SET("PLEC = #{record.plec,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefonKom() != null) {
            sql.SET("TELEFON_KOM = #{record.telefonKom,jdbcType=VARCHAR}");
        }
        
        if (record.getWyznanieId() != null) {
            sql.SET("WYZNANIE_ID = #{record.wyznanieId,jdbcType=BIGINT}");
        }
        
        if (record.getWyksztalcenieId() != null) {
            sql.SET("WYKSZTALCENIE_ID = #{record.wyksztalcenieId,jdbcType=BIGINT}");
        }
        
        if (record.getDataZgonu() != null) {
            sql.SET("DATA_ZGONU = #{record.dataZgonu,jdbcType=DATE}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("OSOBA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("STAN_CYWILNY_ID = #{record.stanCywilnyId,jdbcType=BIGINT}");
        sql.SET("DATA_URODZENIA = #{record.dataUrodzenia,jdbcType=DATE}");
        sql.SET("IMIE = #{record.imie,jdbcType=VARCHAR}");
        sql.SET("IMIE_DRUGIE = #{record.imieDrugie,jdbcType=VARCHAR}");
        sql.SET("IMIE_MATKI = #{record.imieMatki,jdbcType=VARCHAR}");
        sql.SET("IMIE_OJCA = #{record.imieOjca,jdbcType=VARCHAR}");
        sql.SET("IMIE_WSPOLMALZONKA = #{record.imieWspolmalzonka,jdbcType=VARCHAR}");
        sql.SET("IMPORT_PROGRAM = #{record.importProgram,jdbcType=VARCHAR}");
        sql.SET("MIEJSCE_URODZENIA = #{record.miejsceUrodzenia,jdbcType=VARCHAR}");
        sql.SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        sql.SET("NAZWISKO_RODOWE = #{record.nazwiskoRodowe,jdbcType=VARCHAR}");
        sql.SET("NAZWISKO_RODOWE_MATKI = #{record.nazwiskoRodoweMatki,jdbcType=VARCHAR}");
        sql.SET("NAZWISKO_WSPOLMALZONKA = #{record.nazwiskoWspolmalzonka,jdbcType=VARCHAR}");
        sql.SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        sql.SET("PESEL = #{record.pesel,jdbcType=VARCHAR}");
        sql.SET("PLEC = #{record.plec,jdbcType=VARCHAR}");
        sql.SET("TELEFON_KOM = #{record.telefonKom,jdbcType=VARCHAR}");
        sql.SET("WYZNANIE_ID = #{record.wyznanieId,jdbcType=BIGINT}");
        sql.SET("WYKSZTALCENIE_ID = #{record.wyksztalcenieId,jdbcType=BIGINT}");
        sql.SET("DATA_ZGONU = #{record.dataZgonu,jdbcType=DATE}");
        
        OsobaCriteria example = (OsobaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(Osoba record) {
        SQL sql = new SQL();
        sql.UPDATE("OSOBA");
        
        if (record.getStanCywilnyId() != null) {
            sql.SET("STAN_CYWILNY_ID = #{stanCywilnyId,jdbcType=BIGINT}");
        }
        
        if (record.getDataUrodzenia() != null) {
            sql.SET("DATA_URODZENIA = #{dataUrodzenia,jdbcType=DATE}");
        }
        
        if (record.getImie() != null) {
            sql.SET("IMIE = #{imie,jdbcType=VARCHAR}");
        }
        
        if (record.getImieDrugie() != null) {
            sql.SET("IMIE_DRUGIE = #{imieDrugie,jdbcType=VARCHAR}");
        }
        
        if (record.getImieMatki() != null) {
            sql.SET("IMIE_MATKI = #{imieMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getImieOjca() != null) {
            sql.SET("IMIE_OJCA = #{imieOjca,jdbcType=VARCHAR}");
        }
        
        if (record.getImieWspolmalzonka() != null) {
            sql.SET("IMIE_WSPOLMALZONKA = #{imieWspolmalzonka,jdbcType=VARCHAR}");
        }
        
        if (record.getImportProgram() != null) {
            sql.SET("IMPORT_PROGRAM = #{importProgram,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejsceUrodzenia() != null) {
            sql.SET("MIEJSCE_URODZENIA = #{miejsceUrodzenia,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwisko() != null) {
            sql.SET("NAZWISKO = #{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoRodowe() != null) {
            sql.SET("NAZWISKO_RODOWE = #{nazwiskoRodowe,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoRodoweMatki() != null) {
            sql.SET("NAZWISKO_RODOWE_MATKI = #{nazwiskoRodoweMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwiskoWspolmalzonka() != null) {
            sql.SET("NAZWISKO_WSPOLMALZONKA = #{nazwiskoWspolmalzonka,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            sql.SET("NIP = #{nip,jdbcType=VARCHAR}");
        }
        
        if (record.getPesel() != null) {
            sql.SET("PESEL = #{pesel,jdbcType=VARCHAR}");
        }
        
        if (record.getPlec() != null) {
            sql.SET("PLEC = #{plec,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefonKom() != null) {
            sql.SET("TELEFON_KOM = #{telefonKom,jdbcType=VARCHAR}");
        }
        
        if (record.getWyznanieId() != null) {
            sql.SET("WYZNANIE_ID = #{wyznanieId,jdbcType=BIGINT}");
        }
        
        if (record.getWyksztalcenieId() != null) {
            sql.SET("WYKSZTALCENIE_ID = #{wyksztalcenieId,jdbcType=BIGINT}");
        }
        
        if (record.getDataZgonu() != null) {
            sql.SET("DATA_ZGONU = #{dataZgonu,jdbcType=DATE}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, OsobaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}