package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.PobieraneSwiadczenie;
import pl.topteam.dps.model.main_gen.PobieraneSwiadczenieCriteria.Criteria;
import pl.topteam.dps.model.main_gen.PobieraneSwiadczenieCriteria.Criterion;
import pl.topteam.dps.model.main.PobieraneSwiadczenieCriteria;

public class PobieraneSwiadczenieSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(PobieraneSwiadczenieCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("POBIERANE_SWIADCZENIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(PobieraneSwiadczenieCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("POBIERANE_SWIADCZENIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(PobieraneSwiadczenie record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("POBIERANE_SWIADCZENIE");
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieZmienioneId() != null) {
            sql.VALUES("SWIADCZENIE_ZMIENIONE_ID", "#{swiadczenieZmienioneId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        if (record.getDataZmiany() != null) {
            sql.VALUES("DATA_ZMIANY", "#{dataZmiany,jdbcType=DATE}");
        }
        
        if (record.getKwota() != null) {
            sql.VALUES("KWOTA", "#{kwota,jdbcType=DECIMAL}");
        }
        
        if (record.getNr() != null) {
            sql.VALUES("NR", "#{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzajOdbioru() != null) {
            sql.VALUES("RODZAJ_ODBIORU", "#{rodzajOdbioru,jdbcType=VARCHAR}");
        }
        
        if (record.getInstytucjaDoplacajacaId() != null) {
            sql.VALUES("INSTYTUCJA_DOPLACAJACA_ID", "#{instytucjaDoplacajacaId,jdbcType=BIGINT}");
        }
        
        if (record.getTerminWyplatyId() != null) {
            sql.VALUES("TERMIN_WYPLATY_ID", "#{terminWyplatyId,jdbcType=BIGINT}");
        }
        
        if (record.getKodSwiadczeniaId() != null) {
            sql.VALUES("KOD_SWIADCZENIA_ID", "#{kodSwiadczeniaId,jdbcType=BIGINT}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(PobieraneSwiadczenieCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("OSOBA_ID");
        sql.SELECT("SWIADCZENIE_ZMIENIONE_ID");
        sql.SELECT("DATA_OD");
        sql.SELECT("DATA_DO");
        sql.SELECT("DATA_ZMIANY");
        sql.SELECT("KWOTA");
        sql.SELECT("NR");
        sql.SELECT("RODZAJ_ODBIORU");
        sql.SELECT("INSTYTUCJA_DOPLACAJACA_ID");
        sql.SELECT("TERMIN_WYPLATY_ID");
        sql.SELECT("KOD_SWIADCZENIA_ID");
        sql.FROM("POBIERANE_SWIADCZENIE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        PobieraneSwiadczenie record = (PobieraneSwiadczenie) parameter.get("record");
        PobieraneSwiadczenieCriteria example = (PobieraneSwiadczenieCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("POBIERANE_SWIADCZENIE");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieZmienioneId() != null) {
            sql.SET("SWIADCZENIE_ZMIENIONE_ID = #{record.swiadczenieZmienioneId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        if (record.getDataZmiany() != null) {
            sql.SET("DATA_ZMIANY = #{record.dataZmiany,jdbcType=DATE}");
        }
        
        if (record.getKwota() != null) {
            sql.SET("KWOTA = #{record.kwota,jdbcType=DECIMAL}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzajOdbioru() != null) {
            sql.SET("RODZAJ_ODBIORU = #{record.rodzajOdbioru,jdbcType=VARCHAR}");
        }
        
        if (record.getInstytucjaDoplacajacaId() != null) {
            sql.SET("INSTYTUCJA_DOPLACAJACA_ID = #{record.instytucjaDoplacajacaId,jdbcType=BIGINT}");
        }
        
        if (record.getTerminWyplatyId() != null) {
            sql.SET("TERMIN_WYPLATY_ID = #{record.terminWyplatyId,jdbcType=BIGINT}");
        }
        
        if (record.getKodSwiadczeniaId() != null) {
            sql.SET("KOD_SWIADCZENIA_ID = #{record.kodSwiadczeniaId,jdbcType=BIGINT}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("POBIERANE_SWIADCZENIE");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("SWIADCZENIE_ZMIENIONE_ID = #{record.swiadczenieZmienioneId,jdbcType=BIGINT}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        sql.SET("DATA_ZMIANY = #{record.dataZmiany,jdbcType=DATE}");
        sql.SET("KWOTA = #{record.kwota,jdbcType=DECIMAL}");
        sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        sql.SET("RODZAJ_ODBIORU = #{record.rodzajOdbioru,jdbcType=VARCHAR}");
        sql.SET("INSTYTUCJA_DOPLACAJACA_ID = #{record.instytucjaDoplacajacaId,jdbcType=BIGINT}");
        sql.SET("TERMIN_WYPLATY_ID = #{record.terminWyplatyId,jdbcType=BIGINT}");
        sql.SET("KOD_SWIADCZENIA_ID = #{record.kodSwiadczeniaId,jdbcType=BIGINT}");
        
        PobieraneSwiadczenieCriteria example = (PobieraneSwiadczenieCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(PobieraneSwiadczenie record) {
        SQL sql = new SQL();
        sql.UPDATE("POBIERANE_SWIADCZENIE");
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieZmienioneId() != null) {
            sql.SET("SWIADCZENIE_ZMIENIONE_ID = #{swiadczenieZmienioneId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        if (record.getDataZmiany() != null) {
            sql.SET("DATA_ZMIANY = #{dataZmiany,jdbcType=DATE}");
        }
        
        if (record.getKwota() != null) {
            sql.SET("KWOTA = #{kwota,jdbcType=DECIMAL}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzajOdbioru() != null) {
            sql.SET("RODZAJ_ODBIORU = #{rodzajOdbioru,jdbcType=VARCHAR}");
        }
        
        if (record.getInstytucjaDoplacajacaId() != null) {
            sql.SET("INSTYTUCJA_DOPLACAJACA_ID = #{instytucjaDoplacajacaId,jdbcType=BIGINT}");
        }
        
        if (record.getTerminWyplatyId() != null) {
            sql.SET("TERMIN_WYPLATY_ID = #{terminWyplatyId,jdbcType=BIGINT}");
        }
        
        if (record.getKodSwiadczeniaId() != null) {
            sql.SET("KOD_SWIADCZENIA_ID = #{kodSwiadczeniaId,jdbcType=BIGINT}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, PobieraneSwiadczenieCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}