package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.PostanowienieSadu;
import pl.topteam.dps.model.main_gen.PostanowienieSaduCriteria.Criteria;
import pl.topteam.dps.model.main_gen.PostanowienieSaduCriteria.Criterion;
import pl.topteam.dps.model.main.PostanowienieSaduCriteria;

public class PostanowienieSaduSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(PostanowienieSaduCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("POSTANOWIENIE_SADU");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(PostanowienieSaduCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("POSTANOWIENIE_SADU");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(PostanowienieSadu record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("POSTANOWIENIE_SADU");
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzajPostanowieniaId() != null) {
            sql.VALUES("RODZAJ_POSTANOWIENIA_ID", "#{rodzajPostanowieniaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataPostanowienia() != null) {
            sql.VALUES("DATA_POSTANOWIENIA", "#{dataPostanowienia,jdbcType=DATE}");
        }
        
        if (record.getNr() != null) {
            sql.VALUES("NR", "#{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getSadId() != null) {
            sql.VALUES("SAD_ID", "#{sadId,jdbcType=BIGINT}");
        }
        
        if (record.getZakresId() != null) {
            sql.VALUES("ZAKRES_ID", "#{zakresId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getUwagi() != null) {
            sql.VALUES("UWAGI", "#{uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getOpiekunId() != null) {
            sql.VALUES("OPIEKUN_ID", "#{opiekunId,jdbcType=BIGINT}");
        }
        
        if (record.getDataDo() != null) {
            sql.VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(PostanowienieSaduCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("OSOBA_ID");
        sql.SELECT("RODZAJ_POSTANOWIENIA_ID");
        sql.SELECT("DATA_POSTANOWIENIA");
        sql.SELECT("NR");
        sql.SELECT("SAD_ID");
        sql.SELECT("ZAKRES_ID");
        sql.SELECT("DATA_OD");
        sql.SELECT("UWAGI");
        sql.SELECT("OPIEKUN_ID");
        sql.SELECT("DATA_DO");
        sql.FROM("POSTANOWIENIE_SADU");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        PostanowienieSadu record = (PostanowienieSadu) parameter.get("record");
        PostanowienieSaduCriteria example = (PostanowienieSaduCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("POSTANOWIENIE_SADU");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzajPostanowieniaId() != null) {
            sql.SET("RODZAJ_POSTANOWIENIA_ID = #{record.rodzajPostanowieniaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataPostanowienia() != null) {
            sql.SET("DATA_POSTANOWIENIA = #{record.dataPostanowienia,jdbcType=DATE}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        }
        
        if (record.getSadId() != null) {
            sql.SET("SAD_ID = #{record.sadId,jdbcType=BIGINT}");
        }
        
        if (record.getZakresId() != null) {
            sql.SET("ZAKRES_ID = #{record.zakresId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getUwagi() != null) {
            sql.SET("UWAGI = #{record.uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getOpiekunId() != null) {
            sql.SET("OPIEKUN_ID = #{record.opiekunId,jdbcType=BIGINT}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("POSTANOWIENIE_SADU");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("RODZAJ_POSTANOWIENIA_ID = #{record.rodzajPostanowieniaId,jdbcType=BIGINT}");
        sql.SET("DATA_POSTANOWIENIA = #{record.dataPostanowienia,jdbcType=DATE}");
        sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        sql.SET("SAD_ID = #{record.sadId,jdbcType=BIGINT}");
        sql.SET("ZAKRES_ID = #{record.zakresId,jdbcType=BIGINT}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        sql.SET("UWAGI = #{record.uwagi,jdbcType=VARCHAR}");
        sql.SET("OPIEKUN_ID = #{record.opiekunId,jdbcType=BIGINT}");
        sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        
        PostanowienieSaduCriteria example = (PostanowienieSaduCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(PostanowienieSadu record) {
        SQL sql = new SQL();
        sql.UPDATE("POSTANOWIENIE_SADU");
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getRodzajPostanowieniaId() != null) {
            sql.SET("RODZAJ_POSTANOWIENIA_ID = #{rodzajPostanowieniaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataPostanowienia() != null) {
            sql.SET("DATA_POSTANOWIENIA = #{dataPostanowienia,jdbcType=DATE}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getSadId() != null) {
            sql.SET("SAD_ID = #{sadId,jdbcType=BIGINT}");
        }
        
        if (record.getZakresId() != null) {
            sql.SET("ZAKRES_ID = #{zakresId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getUwagi() != null) {
            sql.SET("UWAGI = #{uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getOpiekunId() != null) {
            sql.SET("OPIEKUN_ID = #{opiekunId,jdbcType=BIGINT}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, PostanowienieSaduCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}