package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.Pracownik;
import pl.topteam.dps.model.main_gen.PracownikCriteria.Criteria;
import pl.topteam.dps.model.main_gen.PracownikCriteria.Criterion;
import pl.topteam.dps.model.main.PracownikCriteria;

public class PracownikSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String countByExample(PracownikCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("PRACOWNIK");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String deleteByExample(PracownikCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("PRACOWNIK");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String insertSelective(Pracownik record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("PRACOWNIK");
        
        if (record.getGrupaId() != null) {
            sql.VALUES("GRUPA_ID", "#{grupaId,jdbcType=BIGINT}");
        }
        
        if (record.getCzyPracuje() != null) {
            sql.VALUES("CZY_PRACUJE", "#{czyPracuje,jdbcType=SMALLINT}");
        }
        
        if (record.getDataOstatniegoLogowania() != null) {
            sql.VALUES("DATA_OSTATNIEGO_LOGOWANIA", "#{dataOstatniegoLogowania,jdbcType=TIMESTAMP}");
        }
        
        if (record.getDataZmianyHasla() != null) {
            sql.VALUES("DATA_ZMIANY_HASLA", "#{dataZmianyHasla,jdbcType=DATE}");
        }
        
        if (record.geteMail() != null) {
            sql.VALUES("E_MAIL", "#{eMail,jdbcType=VARCHAR}");
        }
        
        if (record.getLogin() != null) {
            sql.VALUES("LOGIN", "#{login,jdbcType=VARCHAR}");
        }
        
        if (record.getHaslo() != null) {
            sql.VALUES("HASLO", "#{haslo,jdbcType=VARCHAR}");
        }
        
        if (record.getImie() != null) {
            sql.VALUES("IMIE", "#{imie,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaNLogowan() != null) {
            sql.VALUES("LICZBA_N_LOGOWAN", "#{liczbaNLogowan,jdbcType=INTEGER}");
        }
        
        if (record.getNazwisko() != null) {
            sql.VALUES("NAZWISKO", "#{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefon() != null) {
            sql.VALUES("TELEFON", "#{telefon,jdbcType=VARCHAR}");
        }
        
        if (record.getZablokowane() != null) {
            sql.VALUES("ZABLOKOWANE", "#{zablokowane,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String selectByExample(PracownikCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("GRUPA_ID");
        sql.SELECT("CZY_PRACUJE");
        sql.SELECT("DATA_OSTATNIEGO_LOGOWANIA");
        sql.SELECT("DATA_ZMIANY_HASLA");
        sql.SELECT("E_MAIL");
        sql.SELECT("LOGIN");
        sql.SELECT("HASLO");
        sql.SELECT("IMIE");
        sql.SELECT("LICZBA_N_LOGOWAN");
        sql.SELECT("NAZWISKO");
        sql.SELECT("TELEFON");
        sql.SELECT("ZABLOKOWANE");
        sql.FROM("PRACOWNIK");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Pracownik record = (Pracownik) parameter.get("record");
        PracownikCriteria example = (PracownikCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("PRACOWNIK");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getGrupaId() != null) {
            sql.SET("GRUPA_ID = #{record.grupaId,jdbcType=BIGINT}");
        }
        
        if (record.getCzyPracuje() != null) {
            sql.SET("CZY_PRACUJE = #{record.czyPracuje,jdbcType=SMALLINT}");
        }
        
        if (record.getDataOstatniegoLogowania() != null) {
            sql.SET("DATA_OSTATNIEGO_LOGOWANIA = #{record.dataOstatniegoLogowania,jdbcType=TIMESTAMP}");
        }
        
        if (record.getDataZmianyHasla() != null) {
            sql.SET("DATA_ZMIANY_HASLA = #{record.dataZmianyHasla,jdbcType=DATE}");
        }
        
        if (record.geteMail() != null) {
            sql.SET("E_MAIL = #{record.eMail,jdbcType=VARCHAR}");
        }
        
        if (record.getLogin() != null) {
            sql.SET("LOGIN = #{record.login,jdbcType=VARCHAR}");
        }
        
        if (record.getHaslo() != null) {
            sql.SET("HASLO = #{record.haslo,jdbcType=VARCHAR}");
        }
        
        if (record.getImie() != null) {
            sql.SET("IMIE = #{record.imie,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaNLogowan() != null) {
            sql.SET("LICZBA_N_LOGOWAN = #{record.liczbaNLogowan,jdbcType=INTEGER}");
        }
        
        if (record.getNazwisko() != null) {
            sql.SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefon() != null) {
            sql.SET("TELEFON = #{record.telefon,jdbcType=VARCHAR}");
        }
        
        if (record.getZablokowane() != null) {
            sql.SET("ZABLOKOWANE = #{record.zablokowane,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("PRACOWNIK");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("GRUPA_ID = #{record.grupaId,jdbcType=BIGINT}");
        sql.SET("CZY_PRACUJE = #{record.czyPracuje,jdbcType=SMALLINT}");
        sql.SET("DATA_OSTATNIEGO_LOGOWANIA = #{record.dataOstatniegoLogowania,jdbcType=TIMESTAMP}");
        sql.SET("DATA_ZMIANY_HASLA = #{record.dataZmianyHasla,jdbcType=DATE}");
        sql.SET("E_MAIL = #{record.eMail,jdbcType=VARCHAR}");
        sql.SET("LOGIN = #{record.login,jdbcType=VARCHAR}");
        sql.SET("HASLO = #{record.haslo,jdbcType=VARCHAR}");
        sql.SET("IMIE = #{record.imie,jdbcType=VARCHAR}");
        sql.SET("LICZBA_N_LOGOWAN = #{record.liczbaNLogowan,jdbcType=INTEGER}");
        sql.SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        sql.SET("TELEFON = #{record.telefon,jdbcType=VARCHAR}");
        sql.SET("ZABLOKOWANE = #{record.zablokowane,jdbcType=BOOLEAN}");
        
        PracownikCriteria example = (PracownikCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    public String updateByPrimaryKeySelective(Pracownik record) {
        SQL sql = new SQL();
        sql.UPDATE("PRACOWNIK");
        
        if (record.getGrupaId() != null) {
            sql.SET("GRUPA_ID = #{grupaId,jdbcType=BIGINT}");
        }
        
        if (record.getCzyPracuje() != null) {
            sql.SET("CZY_PRACUJE = #{czyPracuje,jdbcType=SMALLINT}");
        }
        
        if (record.getDataOstatniegoLogowania() != null) {
            sql.SET("DATA_OSTATNIEGO_LOGOWANIA = #{dataOstatniegoLogowania,jdbcType=TIMESTAMP}");
        }
        
        if (record.getDataZmianyHasla() != null) {
            sql.SET("DATA_ZMIANY_HASLA = #{dataZmianyHasla,jdbcType=DATE}");
        }
        
        if (record.geteMail() != null) {
            sql.SET("E_MAIL = #{eMail,jdbcType=VARCHAR}");
        }
        
        if (record.getLogin() != null) {
            sql.SET("LOGIN = #{login,jdbcType=VARCHAR}");
        }
        
        if (record.getHaslo() != null) {
            sql.SET("HASLO = #{haslo,jdbcType=VARCHAR}");
        }
        
        if (record.getImie() != null) {
            sql.SET("IMIE = #{imie,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaNLogowan() != null) {
            sql.SET("LICZBA_N_LOGOWAN = #{liczbaNLogowan,jdbcType=INTEGER}");
        }
        
        if (record.getNazwisko() != null) {
            sql.SET("NAZWISKO = #{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefon() != null) {
            sql.SET("TELEFON = #{telefon,jdbcType=VARCHAR}");
        }
        
        if (record.getZablokowane() != null) {
            sql.SET("ZABLOKOWANE = #{zablokowane,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:57
     */
    protected void applyWhere(SQL sql, PracownikCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}