package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.PrzelewDruk;
import pl.topteam.dps.model.main.PrzelewDrukCriteria;

public abstract interface PrzelewDrukMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=PrzelewDrukSqlProvider.class, method="countByExample")
    int countByExample(PrzelewDrukCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=PrzelewDrukSqlProvider.class, method="deleteByExample")
    int deleteByExample(PrzelewDrukCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from PRZELEW_DRUK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into PRZELEW_DRUK (DATA_GENEROWANIA, KWOTA, ",
        "TYTULEM, ZADLUZENIE_POZYCJA_ID)",
        "values (#{dataGenerowania,jdbcType=TIMESTAMP}, #{kwota,jdbcType=DECIMAL}, ",
        "#{tytulem,jdbcType=VARCHAR}, #{zadluzeniePozycjaId,jdbcType=BIGINT})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(PrzelewDruk record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(PrzelewDruk record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=PrzelewDrukSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(PrzelewDruk record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=PrzelewDrukSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_GENEROWANIA", property="dataGenerowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="TYTULEM", property="tytulem", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZADLUZENIE_POZYCJA_ID", property="zadluzeniePozycjaId", jdbcType=JdbcType.BIGINT)
    })
    List<PrzelewDruk> selectByExampleWithRowbounds(PrzelewDrukCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=PrzelewDrukSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_GENEROWANIA", property="dataGenerowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="TYTULEM", property="tytulem", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZADLUZENIE_POZYCJA_ID", property="zadluzeniePozycjaId", jdbcType=JdbcType.BIGINT)
    })
    List<PrzelewDruk> selectByExample(PrzelewDrukCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ID, DATA_GENEROWANIA, KWOTA, TYTULEM, ZADLUZENIE_POZYCJA_ID",
        "from PRZELEW_DRUK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_GENEROWANIA", property="dataGenerowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="TYTULEM", property="tytulem", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZADLUZENIE_POZYCJA_ID", property="zadluzeniePozycjaId", jdbcType=JdbcType.BIGINT)
    })
    PrzelewDruk selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=PrzelewDrukSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") PrzelewDruk record, @Param("example") PrzelewDrukCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=PrzelewDrukSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") PrzelewDruk record, @Param("example") PrzelewDrukCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=PrzelewDrukSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(PrzelewDruk record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update PRZELEW_DRUK",
        "set DATA_GENEROWANIA = #{dataGenerowania,jdbcType=TIMESTAMP},",
          "KWOTA = #{kwota,jdbcType=DECIMAL},",
          "TYTULEM = #{tytulem,jdbcType=VARCHAR},",
          "ZADLUZENIE_POZYCJA_ID = #{zadluzeniePozycjaId,jdbcType=BIGINT}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(PrzelewDruk record);
}