package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.QrtzBlobTriggers;
import pl.topteam.dps.model.main_gen.QrtzBlobTriggersCriteria.Criteria;
import pl.topteam.dps.model.main_gen.QrtzBlobTriggersCriteria.Criterion;
import pl.topteam.dps.model.main.QrtzBlobTriggersCriteria;

public class QrtzBlobTriggersSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(QrtzBlobTriggersCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("QRTZ_BLOB_TRIGGERS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(QrtzBlobTriggersCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("QRTZ_BLOB_TRIGGERS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(QrtzBlobTriggers record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("QRTZ_BLOB_TRIGGERS");
        
        if (record.getSchedName() != null) {
            sql.VALUES("SCHED_NAME", "#{schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerName() != null) {
            sql.VALUES("TRIGGER_NAME", "#{triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.VALUES("TRIGGER_GROUP", "#{triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getBlobData() != null) {
            sql.VALUES("BLOB_DATA", "#{blobData,jdbcType=BLOB}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExampleWithBLOBs(QrtzBlobTriggersCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SCHED_NAME");
        } else {
            sql.SELECT("SCHED_NAME");
        }
        sql.SELECT("TRIGGER_NAME");
        sql.SELECT("TRIGGER_GROUP");
        sql.SELECT("BLOB_DATA");
        sql.FROM("QRTZ_BLOB_TRIGGERS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(QrtzBlobTriggersCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SCHED_NAME");
        } else {
            sql.SELECT("SCHED_NAME");
        }
        sql.SELECT("TRIGGER_NAME");
        sql.SELECT("TRIGGER_GROUP");
        sql.FROM("QRTZ_BLOB_TRIGGERS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        QrtzBlobTriggers record = (QrtzBlobTriggers) parameter.get("record");
        QrtzBlobTriggersCriteria example = (QrtzBlobTriggersCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_BLOB_TRIGGERS");
        
        if (record.getSchedName() != null) {
            sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerName() != null) {
            sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getBlobData() != null) {
            sql.SET("BLOB_DATA = #{record.blobData,jdbcType=BLOB}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleWithBLOBs(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_BLOB_TRIGGERS");
        
        sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        sql.SET("BLOB_DATA = #{record.blobData,jdbcType=BLOB}");
        
        QrtzBlobTriggersCriteria example = (QrtzBlobTriggersCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_BLOB_TRIGGERS");
        
        sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        
        QrtzBlobTriggersCriteria example = (QrtzBlobTriggersCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, QrtzBlobTriggersCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}