package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.QrtzFiredTriggers;
import pl.topteam.dps.model.main.QrtzFiredTriggersCriteria;
import pl.topteam.dps.model.main_gen.QrtzFiredTriggersKey;

public abstract interface QrtzFiredTriggersMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=QrtzFiredTriggersSqlProvider.class, method="countByExample")
    int countByExample(QrtzFiredTriggersCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=QrtzFiredTriggersSqlProvider.class, method="deleteByExample")
    int deleteByExample(QrtzFiredTriggersCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from QRTZ_FIRED_TRIGGERS",
        "where SCHED_NAME = #{schedName,jdbcType=VARCHAR}",
          "and ENTRY_ID = #{entryId,jdbcType=VARCHAR}"
    })
    int deleteByPrimaryKey(QrtzFiredTriggersKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into QRTZ_FIRED_TRIGGERS (SCHED_NAME, ENTRY_ID, ",
        "TRIGGER_NAME, TRIGGER_GROUP, ",
        "INSTANCE_NAME, FIRED_TIME, ",
        "PRIORITY, STATE, ",
        "JOB_NAME, JOB_GROUP, ",
        "IS_NONCONCURRENT, REQUESTS_RECOVERY)",
        "values (#{schedName,jdbcType=VARCHAR}, #{entryId,jdbcType=VARCHAR}, ",
        "#{triggerName,jdbcType=VARCHAR}, #{triggerGroup,jdbcType=VARCHAR}, ",
        "#{instanceName,jdbcType=VARCHAR}, #{firedTime,jdbcType=BIGINT}, ",
        "#{priority,jdbcType=INTEGER}, #{state,jdbcType=VARCHAR}, ",
        "#{jobName,jdbcType=VARCHAR}, #{jobGroup,jdbcType=VARCHAR}, ",
        "#{isNonconcurrent,jdbcType=BOOLEAN}, #{requestsRecovery,jdbcType=BOOLEAN})"
    })
    int insert(QrtzFiredTriggers record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(QrtzFiredTriggers record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=QrtzFiredTriggersSqlProvider.class, method="insertSelective")
    int insertSelective(QrtzFiredTriggers record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=QrtzFiredTriggersSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="SCHED_NAME", property="schedName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="ENTRY_ID", property="entryId", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="TRIGGER_NAME", property="triggerName", jdbcType=JdbcType.VARCHAR),
        @Result(column="TRIGGER_GROUP", property="triggerGroup", jdbcType=JdbcType.VARCHAR),
        @Result(column="INSTANCE_NAME", property="instanceName", jdbcType=JdbcType.VARCHAR),
        @Result(column="FIRED_TIME", property="firedTime", jdbcType=JdbcType.BIGINT),
        @Result(column="PRIORITY", property="priority", jdbcType=JdbcType.INTEGER),
        @Result(column="STATE", property="state", jdbcType=JdbcType.VARCHAR),
        @Result(column="JOB_NAME", property="jobName", jdbcType=JdbcType.VARCHAR),
        @Result(column="JOB_GROUP", property="jobGroup", jdbcType=JdbcType.VARCHAR),
        @Result(column="IS_NONCONCURRENT", property="isNonconcurrent", jdbcType=JdbcType.BOOLEAN),
        @Result(column="REQUESTS_RECOVERY", property="requestsRecovery", jdbcType=JdbcType.BOOLEAN)
    })
    List<QrtzFiredTriggers> selectByExampleWithRowbounds(QrtzFiredTriggersCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=QrtzFiredTriggersSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="SCHED_NAME", property="schedName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="ENTRY_ID", property="entryId", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="TRIGGER_NAME", property="triggerName", jdbcType=JdbcType.VARCHAR),
        @Result(column="TRIGGER_GROUP", property="triggerGroup", jdbcType=JdbcType.VARCHAR),
        @Result(column="INSTANCE_NAME", property="instanceName", jdbcType=JdbcType.VARCHAR),
        @Result(column="FIRED_TIME", property="firedTime", jdbcType=JdbcType.BIGINT),
        @Result(column="PRIORITY", property="priority", jdbcType=JdbcType.INTEGER),
        @Result(column="STATE", property="state", jdbcType=JdbcType.VARCHAR),
        @Result(column="JOB_NAME", property="jobName", jdbcType=JdbcType.VARCHAR),
        @Result(column="JOB_GROUP", property="jobGroup", jdbcType=JdbcType.VARCHAR),
        @Result(column="IS_NONCONCURRENT", property="isNonconcurrent", jdbcType=JdbcType.BOOLEAN),
        @Result(column="REQUESTS_RECOVERY", property="requestsRecovery", jdbcType=JdbcType.BOOLEAN)
    })
    List<QrtzFiredTriggers> selectByExample(QrtzFiredTriggersCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "SCHED_NAME, ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, INSTANCE_NAME, FIRED_TIME, ",
        "PRIORITY, STATE, JOB_NAME, JOB_GROUP, IS_NONCONCURRENT, REQUESTS_RECOVERY",
        "from QRTZ_FIRED_TRIGGERS",
        "where SCHED_NAME = #{schedName,jdbcType=VARCHAR}",
          "and ENTRY_ID = #{entryId,jdbcType=VARCHAR}"
    })
    @Results({
        @Result(column="SCHED_NAME", property="schedName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="ENTRY_ID", property="entryId", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="TRIGGER_NAME", property="triggerName", jdbcType=JdbcType.VARCHAR),
        @Result(column="TRIGGER_GROUP", property="triggerGroup", jdbcType=JdbcType.VARCHAR),
        @Result(column="INSTANCE_NAME", property="instanceName", jdbcType=JdbcType.VARCHAR),
        @Result(column="FIRED_TIME", property="firedTime", jdbcType=JdbcType.BIGINT),
        @Result(column="PRIORITY", property="priority", jdbcType=JdbcType.INTEGER),
        @Result(column="STATE", property="state", jdbcType=JdbcType.VARCHAR),
        @Result(column="JOB_NAME", property="jobName", jdbcType=JdbcType.VARCHAR),
        @Result(column="JOB_GROUP", property="jobGroup", jdbcType=JdbcType.VARCHAR),
        @Result(column="IS_NONCONCURRENT", property="isNonconcurrent", jdbcType=JdbcType.BOOLEAN),
        @Result(column="REQUESTS_RECOVERY", property="requestsRecovery", jdbcType=JdbcType.BOOLEAN)
    })
    QrtzFiredTriggers selectByPrimaryKey(QrtzFiredTriggersKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=QrtzFiredTriggersSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") QrtzFiredTriggers record, @Param("example") QrtzFiredTriggersCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=QrtzFiredTriggersSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") QrtzFiredTriggers record, @Param("example") QrtzFiredTriggersCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=QrtzFiredTriggersSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(QrtzFiredTriggers record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update QRTZ_FIRED_TRIGGERS",
        "set TRIGGER_NAME = #{triggerName,jdbcType=VARCHAR},",
          "TRIGGER_GROUP = #{triggerGroup,jdbcType=VARCHAR},",
          "INSTANCE_NAME = #{instanceName,jdbcType=VARCHAR},",
          "FIRED_TIME = #{firedTime,jdbcType=BIGINT},",
          "PRIORITY = #{priority,jdbcType=INTEGER},",
          "STATE = #{state,jdbcType=VARCHAR},",
          "JOB_NAME = #{jobName,jdbcType=VARCHAR},",
          "JOB_GROUP = #{jobGroup,jdbcType=VARCHAR},",
          "IS_NONCONCURRENT = #{isNonconcurrent,jdbcType=BOOLEAN},",
          "REQUESTS_RECOVERY = #{requestsRecovery,jdbcType=BOOLEAN}",
        "where SCHED_NAME = #{schedName,jdbcType=VARCHAR}",
          "and ENTRY_ID = #{entryId,jdbcType=VARCHAR}"
    })
    int updateByPrimaryKey(QrtzFiredTriggers record);
}