package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.QrtzSchedulerState;
import pl.topteam.dps.model.main.QrtzSchedulerStateCriteria;
import pl.topteam.dps.model.main_gen.QrtzSchedulerStateKey;

public abstract interface QrtzSchedulerStateMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=QrtzSchedulerStateSqlProvider.class, method="countByExample")
    int countByExample(QrtzSchedulerStateCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=QrtzSchedulerStateSqlProvider.class, method="deleteByExample")
    int deleteByExample(QrtzSchedulerStateCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from QRTZ_SCHEDULER_STATE",
        "where SCHED_NAME = #{schedName,jdbcType=VARCHAR}",
          "and INSTANCE_NAME = #{instanceName,jdbcType=VARCHAR}"
    })
    int deleteByPrimaryKey(QrtzSchedulerStateKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into QRTZ_SCHEDULER_STATE (SCHED_NAME, INSTANCE_NAME, ",
        "LAST_CHECKIN_TIME, CHECKIN_INTERVAL)",
        "values (#{schedName,jdbcType=VARCHAR}, #{instanceName,jdbcType=VARCHAR}, ",
        "#{lastCheckinTime,jdbcType=BIGINT}, #{checkinInterval,jdbcType=BIGINT})"
    })
    int insert(QrtzSchedulerState record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(QrtzSchedulerState record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=QrtzSchedulerStateSqlProvider.class, method="insertSelective")
    int insertSelective(QrtzSchedulerState record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=QrtzSchedulerStateSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="SCHED_NAME", property="schedName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="INSTANCE_NAME", property="instanceName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="LAST_CHECKIN_TIME", property="lastCheckinTime", jdbcType=JdbcType.BIGINT),
        @Result(column="CHECKIN_INTERVAL", property="checkinInterval", jdbcType=JdbcType.BIGINT)
    })
    List<QrtzSchedulerState> selectByExampleWithRowbounds(QrtzSchedulerStateCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=QrtzSchedulerStateSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="SCHED_NAME", property="schedName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="INSTANCE_NAME", property="instanceName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="LAST_CHECKIN_TIME", property="lastCheckinTime", jdbcType=JdbcType.BIGINT),
        @Result(column="CHECKIN_INTERVAL", property="checkinInterval", jdbcType=JdbcType.BIGINT)
    })
    List<QrtzSchedulerState> selectByExample(QrtzSchedulerStateCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL",
        "from QRTZ_SCHEDULER_STATE",
        "where SCHED_NAME = #{schedName,jdbcType=VARCHAR}",
          "and INSTANCE_NAME = #{instanceName,jdbcType=VARCHAR}"
    })
    @Results({
        @Result(column="SCHED_NAME", property="schedName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="INSTANCE_NAME", property="instanceName", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="LAST_CHECKIN_TIME", property="lastCheckinTime", jdbcType=JdbcType.BIGINT),
        @Result(column="CHECKIN_INTERVAL", property="checkinInterval", jdbcType=JdbcType.BIGINT)
    })
    QrtzSchedulerState selectByPrimaryKey(QrtzSchedulerStateKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=QrtzSchedulerStateSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") QrtzSchedulerState record, @Param("example") QrtzSchedulerStateCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=QrtzSchedulerStateSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") QrtzSchedulerState record, @Param("example") QrtzSchedulerStateCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=QrtzSchedulerStateSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(QrtzSchedulerState record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update QRTZ_SCHEDULER_STATE",
        "set LAST_CHECKIN_TIME = #{lastCheckinTime,jdbcType=BIGINT},",
          "CHECKIN_INTERVAL = #{checkinInterval,jdbcType=BIGINT}",
        "where SCHED_NAME = #{schedName,jdbcType=VARCHAR}",
          "and INSTANCE_NAME = #{instanceName,jdbcType=VARCHAR}"
    })
    int updateByPrimaryKey(QrtzSchedulerState record);
}