package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.QrtzSchedulerState;
import pl.topteam.dps.model.main_gen.QrtzSchedulerStateCriteria.Criteria;
import pl.topteam.dps.model.main_gen.QrtzSchedulerStateCriteria.Criterion;
import pl.topteam.dps.model.main.QrtzSchedulerStateCriteria;

public class QrtzSchedulerStateSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(QrtzSchedulerStateCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("QRTZ_SCHEDULER_STATE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(QrtzSchedulerStateCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("QRTZ_SCHEDULER_STATE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(QrtzSchedulerState record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("QRTZ_SCHEDULER_STATE");
        
        if (record.getSchedName() != null) {
            sql.VALUES("SCHED_NAME", "#{schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getInstanceName() != null) {
            sql.VALUES("INSTANCE_NAME", "#{instanceName,jdbcType=VARCHAR}");
        }
        
        if (record.getLastCheckinTime() != null) {
            sql.VALUES("LAST_CHECKIN_TIME", "#{lastCheckinTime,jdbcType=BIGINT}");
        }
        
        if (record.getCheckinInterval() != null) {
            sql.VALUES("CHECKIN_INTERVAL", "#{checkinInterval,jdbcType=BIGINT}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(QrtzSchedulerStateCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SCHED_NAME");
        } else {
            sql.SELECT("SCHED_NAME");
        }
        sql.SELECT("INSTANCE_NAME");
        sql.SELECT("LAST_CHECKIN_TIME");
        sql.SELECT("CHECKIN_INTERVAL");
        sql.FROM("QRTZ_SCHEDULER_STATE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        QrtzSchedulerState record = (QrtzSchedulerState) parameter.get("record");
        QrtzSchedulerStateCriteria example = (QrtzSchedulerStateCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_SCHEDULER_STATE");
        
        if (record.getSchedName() != null) {
            sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getInstanceName() != null) {
            sql.SET("INSTANCE_NAME = #{record.instanceName,jdbcType=VARCHAR}");
        }
        
        if (record.getLastCheckinTime() != null) {
            sql.SET("LAST_CHECKIN_TIME = #{record.lastCheckinTime,jdbcType=BIGINT}");
        }
        
        if (record.getCheckinInterval() != null) {
            sql.SET("CHECKIN_INTERVAL = #{record.checkinInterval,jdbcType=BIGINT}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_SCHEDULER_STATE");
        
        sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        sql.SET("INSTANCE_NAME = #{record.instanceName,jdbcType=VARCHAR}");
        sql.SET("LAST_CHECKIN_TIME = #{record.lastCheckinTime,jdbcType=BIGINT}");
        sql.SET("CHECKIN_INTERVAL = #{record.checkinInterval,jdbcType=BIGINT}");
        
        QrtzSchedulerStateCriteria example = (QrtzSchedulerStateCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(QrtzSchedulerState record) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_SCHEDULER_STATE");
        
        if (record.getLastCheckinTime() != null) {
            sql.SET("LAST_CHECKIN_TIME = #{lastCheckinTime,jdbcType=BIGINT}");
        }
        
        if (record.getCheckinInterval() != null) {
            sql.SET("CHECKIN_INTERVAL = #{checkinInterval,jdbcType=BIGINT}");
        }
        
        sql.WHERE("SCHED_NAME = #{schedName,jdbcType=VARCHAR}");
        sql.WHERE("INSTANCE_NAME = #{instanceName,jdbcType=VARCHAR}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, QrtzSchedulerStateCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}