package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.RozliczenieSwiadczenie;
import pl.topteam.dps.model.main.RozliczenieSwiadczenieCriteria;
import pl.topteam.dps.model.main_gen.RozliczenieSwiadczenieKey;

public abstract interface RozliczenieSwiadczenieMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="countByExample")
    int countByExample(RozliczenieSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="deleteByExample")
    int deleteByExample(RozliczenieSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from ROZLICZENIE_SWIADCZENIE",
        "where ROZLICZENIE_ID = #{rozliczenieId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(RozliczenieSwiadczenieKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into ROZLICZENIE_SWIADCZENIE (ROZLICZENIE_ID, SWIADCZENIE_ID, ",
        "ILOSC, ILOSC_PELNOPLATNE, ",
        "ILOSC_ZREZYGNOWANO, KWOTA_M, ",
        "KWOTA_DOM, KWOTA_PELNOPLATNE)",
        "values (#{rozliczenieId,jdbcType=BIGINT}, #{swiadczenieId,jdbcType=BIGINT}, ",
        "#{ilosc,jdbcType=DECIMAL}, #{iloscPelnoplatne,jdbcType=DECIMAL}, ",
        "#{iloscZrezygnowano,jdbcType=DECIMAL}, #{kwotaM,jdbcType=DECIMAL}, ",
        "#{kwotaDom,jdbcType=DECIMAL}, #{kwotaPelnoplatne,jdbcType=DECIMAL})"
    })
    int insert(RozliczenieSwiadczenie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(RozliczenieSwiadczenie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="insertSelective")
    int insertSelective(RozliczenieSwiadczenie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ROZLICZENIE_ID", property="rozliczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC", property="ilosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_PELNOPLATNE", property="iloscPelnoplatne", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_ZREZYGNOWANO", property="iloscZrezygnowano", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_M", property="kwotaM", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_DOM", property="kwotaDom", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_PELNOPLATNE", property="kwotaPelnoplatne", jdbcType=JdbcType.DECIMAL)
    })
    List<RozliczenieSwiadczenie> selectByExampleWithRowbounds(RozliczenieSwiadczenieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ROZLICZENIE_ID", property="rozliczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC", property="ilosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_PELNOPLATNE", property="iloscPelnoplatne", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_ZREZYGNOWANO", property="iloscZrezygnowano", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_M", property="kwotaM", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_DOM", property="kwotaDom", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_PELNOPLATNE", property="kwotaPelnoplatne", jdbcType=JdbcType.DECIMAL)
    })
    List<RozliczenieSwiadczenie> selectByExample(RozliczenieSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ROZLICZENIE_ID, SWIADCZENIE_ID, ILOSC, ILOSC_PELNOPLATNE, ILOSC_ZREZYGNOWANO, ",
        "KWOTA_M, KWOTA_DOM, KWOTA_PELNOPLATNE",
        "from ROZLICZENIE_SWIADCZENIE",
        "where ROZLICZENIE_ID = #{rozliczenieId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ROZLICZENIE_ID", property="rozliczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC", property="ilosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_PELNOPLATNE", property="iloscPelnoplatne", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_ZREZYGNOWANO", property="iloscZrezygnowano", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_M", property="kwotaM", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_DOM", property="kwotaDom", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_PELNOPLATNE", property="kwotaPelnoplatne", jdbcType=JdbcType.DECIMAL)
    })
    RozliczenieSwiadczenie selectByPrimaryKey(RozliczenieSwiadczenieKey key);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") RozliczenieSwiadczenie record, @Param("example") RozliczenieSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") RozliczenieSwiadczenie record, @Param("example") RozliczenieSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=RozliczenieSwiadczenieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(RozliczenieSwiadczenie record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update ROZLICZENIE_SWIADCZENIE",
        "set ILOSC = #{ilosc,jdbcType=DECIMAL},",
          "ILOSC_PELNOPLATNE = #{iloscPelnoplatne,jdbcType=DECIMAL},",
          "ILOSC_ZREZYGNOWANO = #{iloscZrezygnowano,jdbcType=DECIMAL},",
          "KWOTA_M = #{kwotaM,jdbcType=DECIMAL},",
          "KWOTA_DOM = #{kwotaDom,jdbcType=DECIMAL},",
          "KWOTA_PELNOPLATNE = #{kwotaPelnoplatne,jdbcType=DECIMAL}",
        "where ROZLICZENIE_ID = #{rozliczenieId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(RozliczenieSwiadczenie record);
}