package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.RozliczenieSwiadczenie;
import pl.topteam.dps.model.main_gen.RozliczenieSwiadczenieCriteria.Criteria;
import pl.topteam.dps.model.main_gen.RozliczenieSwiadczenieCriteria.Criterion;
import pl.topteam.dps.model.main.RozliczenieSwiadczenieCriteria;

public class RozliczenieSwiadczenieSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(RozliczenieSwiadczenieCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ROZLICZENIE_SWIADCZENIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(RozliczenieSwiadczenieCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ROZLICZENIE_SWIADCZENIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(RozliczenieSwiadczenie record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ROZLICZENIE_SWIADCZENIE");
        
        if (record.getRozliczenieId() != null) {
            sql.VALUES("ROZLICZENIE_ID", "#{rozliczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieId() != null) {
            sql.VALUES("SWIADCZENIE_ID", "#{swiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getIlosc() != null) {
            sql.VALUES("ILOSC", "#{ilosc,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscPelnoplatne() != null) {
            sql.VALUES("ILOSC_PELNOPLATNE", "#{iloscPelnoplatne,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscZrezygnowano() != null) {
            sql.VALUES("ILOSC_ZREZYGNOWANO", "#{iloscZrezygnowano,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaM() != null) {
            sql.VALUES("KWOTA_M", "#{kwotaM,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaDom() != null) {
            sql.VALUES("KWOTA_DOM", "#{kwotaDom,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaPelnoplatne() != null) {
            sql.VALUES("KWOTA_PELNOPLATNE", "#{kwotaPelnoplatne,jdbcType=DECIMAL}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(RozliczenieSwiadczenieCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ROZLICZENIE_ID");
        } else {
            sql.SELECT("ROZLICZENIE_ID");
        }
        sql.SELECT("SWIADCZENIE_ID");
        sql.SELECT("ILOSC");
        sql.SELECT("ILOSC_PELNOPLATNE");
        sql.SELECT("ILOSC_ZREZYGNOWANO");
        sql.SELECT("KWOTA_M");
        sql.SELECT("KWOTA_DOM");
        sql.SELECT("KWOTA_PELNOPLATNE");
        sql.FROM("ROZLICZENIE_SWIADCZENIE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        RozliczenieSwiadczenie record = (RozliczenieSwiadczenie) parameter.get("record");
        RozliczenieSwiadczenieCriteria example = (RozliczenieSwiadczenieCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ROZLICZENIE_SWIADCZENIE");
        
        if (record.getRozliczenieId() != null) {
            sql.SET("ROZLICZENIE_ID = #{record.rozliczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieId() != null) {
            sql.SET("SWIADCZENIE_ID = #{record.swiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getIlosc() != null) {
            sql.SET("ILOSC = #{record.ilosc,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscPelnoplatne() != null) {
            sql.SET("ILOSC_PELNOPLATNE = #{record.iloscPelnoplatne,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscZrezygnowano() != null) {
            sql.SET("ILOSC_ZREZYGNOWANO = #{record.iloscZrezygnowano,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaM() != null) {
            sql.SET("KWOTA_M = #{record.kwotaM,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaDom() != null) {
            sql.SET("KWOTA_DOM = #{record.kwotaDom,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaPelnoplatne() != null) {
            sql.SET("KWOTA_PELNOPLATNE = #{record.kwotaPelnoplatne,jdbcType=DECIMAL}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ROZLICZENIE_SWIADCZENIE");
        
        sql.SET("ROZLICZENIE_ID = #{record.rozliczenieId,jdbcType=BIGINT}");
        sql.SET("SWIADCZENIE_ID = #{record.swiadczenieId,jdbcType=BIGINT}");
        sql.SET("ILOSC = #{record.ilosc,jdbcType=DECIMAL}");
        sql.SET("ILOSC_PELNOPLATNE = #{record.iloscPelnoplatne,jdbcType=DECIMAL}");
        sql.SET("ILOSC_ZREZYGNOWANO = #{record.iloscZrezygnowano,jdbcType=DECIMAL}");
        sql.SET("KWOTA_M = #{record.kwotaM,jdbcType=DECIMAL}");
        sql.SET("KWOTA_DOM = #{record.kwotaDom,jdbcType=DECIMAL}");
        sql.SET("KWOTA_PELNOPLATNE = #{record.kwotaPelnoplatne,jdbcType=DECIMAL}");
        
        RozliczenieSwiadczenieCriteria example = (RozliczenieSwiadczenieCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(RozliczenieSwiadczenie record) {
        SQL sql = new SQL();
        sql.UPDATE("ROZLICZENIE_SWIADCZENIE");
        
        if (record.getIlosc() != null) {
            sql.SET("ILOSC = #{ilosc,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscPelnoplatne() != null) {
            sql.SET("ILOSC_PELNOPLATNE = #{iloscPelnoplatne,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscZrezygnowano() != null) {
            sql.SET("ILOSC_ZREZYGNOWANO = #{iloscZrezygnowano,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaM() != null) {
            sql.SET("KWOTA_M = #{kwotaM,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaDom() != null) {
            sql.SET("KWOTA_DOM = #{kwotaDom,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaPelnoplatne() != null) {
            sql.SET("KWOTA_PELNOPLATNE = #{kwotaPelnoplatne,jdbcType=DECIMAL}");
        }
        
        sql.WHERE("ROZLICZENIE_ID = #{rozliczenieId,jdbcType=BIGINT}");
        sql.WHERE("SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, RozliczenieSwiadczenieCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}