package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.SzablonBlokFtl;
import pl.topteam.dps.model.main_gen.SzablonBlokFtlCriteria.Criteria;
import pl.topteam.dps.model.main_gen.SzablonBlokFtlCriteria.Criterion;
import pl.topteam.dps.model.main.SzablonBlokFtlCriteria;

public class SzablonBlokFtlSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(SzablonBlokFtlCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("SZABLON_BLOK_FTL");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(SzablonBlokFtlCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("SZABLON_BLOK_FTL");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(SzablonBlokFtl record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("SZABLON_BLOK_FTL");
        
        if (record.getSzablonWydrukuId() != null) {
            sql.VALUES("SZABLON_WYDRUKU_ID", "#{szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getBlok() != null) {
            sql.VALUES("BLOK", "#{blok,jdbcType=VARCHAR}");
        }
        
        if (record.getNumerPorzadkowy() != null) {
            sql.VALUES("NUMER_PORZADKOWY", "#{numerPorzadkowy,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(SzablonBlokFtlCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("SZABLON_WYDRUKU_ID");
        sql.SELECT("BLOK");
        sql.SELECT("NUMER_PORZADKOWY");
        sql.FROM("SZABLON_BLOK_FTL");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        SzablonBlokFtl record = (SzablonBlokFtl) parameter.get("record");
        SzablonBlokFtlCriteria example = (SzablonBlokFtlCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("SZABLON_BLOK_FTL");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getSzablonWydrukuId() != null) {
            sql.SET("SZABLON_WYDRUKU_ID = #{record.szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getBlok() != null) {
            sql.SET("BLOK = #{record.blok,jdbcType=VARCHAR}");
        }
        
        if (record.getNumerPorzadkowy() != null) {
            sql.SET("NUMER_PORZADKOWY = #{record.numerPorzadkowy,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("SZABLON_BLOK_FTL");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("SZABLON_WYDRUKU_ID = #{record.szablonWydrukuId,jdbcType=BIGINT}");
        sql.SET("BLOK = #{record.blok,jdbcType=VARCHAR}");
        sql.SET("NUMER_PORZADKOWY = #{record.numerPorzadkowy,jdbcType=INTEGER}");
        
        SzablonBlokFtlCriteria example = (SzablonBlokFtlCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(SzablonBlokFtl record) {
        SQL sql = new SQL();
        sql.UPDATE("SZABLON_BLOK_FTL");
        
        if (record.getSzablonWydrukuId() != null) {
            sql.SET("SZABLON_WYDRUKU_ID = #{szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getBlok() != null) {
            sql.SET("BLOK = #{blok,jdbcType=VARCHAR}");
        }
        
        if (record.getNumerPorzadkowy() != null) {
            sql.SET("NUMER_PORZADKOWY = #{numerPorzadkowy,jdbcType=INTEGER}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, SzablonBlokFtlCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}