package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.UwagiRealizacjaPlanu;
import pl.topteam.dps.model.main.UwagiRealizacjaPlanuCriteria;

public abstract interface UwagiRealizacjaPlanuMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="countByExample")
    int countByExample(UwagiRealizacjaPlanuCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="deleteByExample")
    int deleteByExample(UwagiRealizacjaPlanuCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from UWAGI_REALIZACJA_PLANU",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into UWAGI_REALIZACJA_PLANU (PLAN_WSPARCIA_REALIZACJA_ID, UWAGI)",
        "values (#{planWsparciaRealizacjaId,jdbcType=BIGINT}, #{uwagi,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(UwagiRealizacjaPlanu record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(UwagiRealizacjaPlanu record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(UwagiRealizacjaPlanu record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PLAN_WSPARCIA_REALIZACJA_ID", property="planWsparciaRealizacjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="UWAGI", property="uwagi", jdbcType=JdbcType.VARCHAR)
    })
    List<UwagiRealizacjaPlanu> selectByExampleWithRowbounds(UwagiRealizacjaPlanuCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PLAN_WSPARCIA_REALIZACJA_ID", property="planWsparciaRealizacjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="UWAGI", property="uwagi", jdbcType=JdbcType.VARCHAR)
    })
    List<UwagiRealizacjaPlanu> selectByExample(UwagiRealizacjaPlanuCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ID, PLAN_WSPARCIA_REALIZACJA_ID, UWAGI",
        "from UWAGI_REALIZACJA_PLANU",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PLAN_WSPARCIA_REALIZACJA_ID", property="planWsparciaRealizacjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="UWAGI", property="uwagi", jdbcType=JdbcType.VARCHAR)
    })
    UwagiRealizacjaPlanu selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") UwagiRealizacjaPlanu record, @Param("example") UwagiRealizacjaPlanuCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") UwagiRealizacjaPlanu record, @Param("example") UwagiRealizacjaPlanuCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=UwagiRealizacjaPlanuSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(UwagiRealizacjaPlanu record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update UWAGI_REALIZACJA_PLANU",
        "set PLAN_WSPARCIA_REALIZACJA_ID = #{planWsparciaRealizacjaId,jdbcType=BIGINT},",
          "UWAGI = #{uwagi,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(UwagiRealizacjaPlanu record);
}