package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Wplata;
import pl.topteam.dps.model.main.WplataCriteria;

public abstract interface WplataMapper {
    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=WplataSqlProvider.class, method="countByExample")
    int countByExample(WplataCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @DeleteProvider(type=WplataSqlProvider.class, method="deleteByExample")
    int deleteByExample(WplataCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Delete({
        "delete from WPLATA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Insert({
        "insert into WPLATA (INSTYTUCJA_ID, OSOBA_ID, ",
        "DATA_WPLATY, KWOTA, ",
        "KWOTA_ZWROT, DATA_KSIEGOWANIA, ",
        "SWIADCZENIE_ID)",
        "values (#{instytucjaId,jdbcType=BIGINT}, #{osobaId,jdbcType=BIGINT}, ",
        "#{dataWplaty,jdbcType=DATE}, #{kwota,jdbcType=DECIMAL}, ",
        "#{kwotaZwrot,jdbcType=DECIMAL}, #{dataKsiegowania,jdbcType=DATE}, ",
        "#{swiadczenieId,jdbcType=BIGINT})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Wplata record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    int mergeInto(Wplata record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @InsertProvider(type=WplataSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Wplata record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=WplataSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INSTYTUCJA_ID", property="instytucjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_WPLATY", property="dataWplaty", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_ZWROT", property="kwotaZwrot", jdbcType=JdbcType.DECIMAL),
        @Result(column="DATA_KSIEGOWANIA", property="dataKsiegowania", jdbcType=JdbcType.DATE),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT)
    })
    List<Wplata> selectByExampleWithRowbounds(WplataCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @SelectProvider(type=WplataSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INSTYTUCJA_ID", property="instytucjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_WPLATY", property="dataWplaty", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_ZWROT", property="kwotaZwrot", jdbcType=JdbcType.DECIMAL),
        @Result(column="DATA_KSIEGOWANIA", property="dataKsiegowania", jdbcType=JdbcType.DATE),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT)
    })
    List<Wplata> selectByExample(WplataCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Select({
        "select",
        "ID, INSTYTUCJA_ID, OSOBA_ID, DATA_WPLATY, KWOTA, KWOTA_ZWROT, DATA_KSIEGOWANIA, ",
        "SWIADCZENIE_ID",
        "from WPLATA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INSTYTUCJA_ID", property="instytucjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_WPLATY", property="dataWplaty", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="KWOTA_ZWROT", property="kwotaZwrot", jdbcType=JdbcType.DECIMAL),
        @Result(column="DATA_KSIEGOWANIA", property="dataKsiegowania", jdbcType=JdbcType.DATE),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT)
    })
    Wplata selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=WplataSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Wplata record, @Param("example") WplataCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=WplataSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Wplata record, @Param("example") WplataCriteria example);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @UpdateProvider(type=WplataSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Wplata record);

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    @Update({
        "update WPLATA",
        "set INSTYTUCJA_ID = #{instytucjaId,jdbcType=BIGINT},",
          "OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "DATA_WPLATY = #{dataWplaty,jdbcType=DATE},",
          "KWOTA = #{kwota,jdbcType=DECIMAL},",
          "KWOTA_ZWROT = #{kwotaZwrot,jdbcType=DECIMAL},",
          "DATA_KSIEGOWANIA = #{dataKsiegowania,jdbcType=DATE},",
          "SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Wplata record);
}