package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZebranieZto;
import pl.topteam.dps.model.main_gen.ZebranieZtoCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZebranieZtoCriteria.Criterion;
import pl.topteam.dps.model.main.ZebranieZtoCriteria;

public class ZebranieZtoSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(ZebranieZtoCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZEBRANIE_ZTO");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(ZebranieZtoCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZEBRANIE_ZTO");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(ZebranieZto record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZEBRANIE_ZTO");
        
        if (record.getSzablonWydrukuId() != null) {
            sql.VALUES("SZABLON_WYDRUKU_ID", "#{szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getData() != null) {
            sql.VALUES("DATA", "#{data,jdbcType=DATE}");
        }
        
        if (record.getDataPlan() != null) {
            sql.VALUES("DATA_PLAN", "#{dataPlan,jdbcType=DATE}");
        }
        
        if (record.getGodzinaPlan() != null) {
            sql.VALUES("GODZINA_PLAN", "#{godzinaPlan,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscePlan() != null) {
            sql.VALUES("MIEJSCE_PLAN", "#{miejscePlan,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(ZebranieZtoCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("SZABLON_WYDRUKU_ID");
        sql.SELECT("DATA");
        sql.SELECT("DATA_PLAN");
        sql.SELECT("GODZINA_PLAN");
        sql.SELECT("MIEJSCE_PLAN");
        sql.FROM("ZEBRANIE_ZTO");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZebranieZto record = (ZebranieZto) parameter.get("record");
        ZebranieZtoCriteria example = (ZebranieZtoCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZEBRANIE_ZTO");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getSzablonWydrukuId() != null) {
            sql.SET("SZABLON_WYDRUKU_ID = #{record.szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getData() != null) {
            sql.SET("DATA = #{record.data,jdbcType=DATE}");
        }
        
        if (record.getDataPlan() != null) {
            sql.SET("DATA_PLAN = #{record.dataPlan,jdbcType=DATE}");
        }
        
        if (record.getGodzinaPlan() != null) {
            sql.SET("GODZINA_PLAN = #{record.godzinaPlan,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscePlan() != null) {
            sql.SET("MIEJSCE_PLAN = #{record.miejscePlan,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZEBRANIE_ZTO");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("SZABLON_WYDRUKU_ID = #{record.szablonWydrukuId,jdbcType=BIGINT}");
        sql.SET("DATA = #{record.data,jdbcType=DATE}");
        sql.SET("DATA_PLAN = #{record.dataPlan,jdbcType=DATE}");
        sql.SET("GODZINA_PLAN = #{record.godzinaPlan,jdbcType=VARCHAR}");
        sql.SET("MIEJSCE_PLAN = #{record.miejscePlan,jdbcType=VARCHAR}");
        
        ZebranieZtoCriteria example = (ZebranieZtoCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(ZebranieZto record) {
        SQL sql = new SQL();
        sql.UPDATE("ZEBRANIE_ZTO");
        
        if (record.getSzablonWydrukuId() != null) {
            sql.SET("SZABLON_WYDRUKU_ID = #{szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getData() != null) {
            sql.SET("DATA = #{data,jdbcType=DATE}");
        }
        
        if (record.getDataPlan() != null) {
            sql.SET("DATA_PLAN = #{dataPlan,jdbcType=DATE}");
        }
        
        if (record.getGodzinaPlan() != null) {
            sql.SET("GODZINA_PLAN = #{godzinaPlan,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscePlan() != null) {
            sql.SET("MIEJSCE_PLAN = #{miejscePlan,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, ZebranieZtoCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}