package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZlecenieUprawnienia;
import pl.topteam.dps.model.main_gen.ZlecenieUprawnieniaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZlecenieUprawnieniaCriteria.Criterion;
import pl.topteam.dps.model.main.ZlecenieUprawnieniaCriteria;

public class ZlecenieUprawnieniaSqlProvider {

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String countByExample(ZlecenieUprawnieniaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZLECENIE_UPRAWNIENIA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String deleteByExample(ZlecenieUprawnieniaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZLECENIE_UPRAWNIENIA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String insertSelective(ZlecenieUprawnienia record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZLECENIE_UPRAWNIENIA");
        
        if (record.getZlecenieId() != null) {
            sql.VALUES("ZLECENIE_ID", "#{zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getKodTytuluUpr() != null) {
            sql.VALUES("KOD_TYTULU_UPR", "#{kodTytuluUpr,jdbcType=VARCHAR}");
        }
        
        if (record.getKodTytuluUprDod() != null) {
            sql.VALUES("KOD_TYTULU_UPR_DOD", "#{kodTytuluUprDod,jdbcType=VARCHAR}");
        }
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        if (record.getKod() != null) {
            sql.VALUES("KOD", "#{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam1() != null) {
            sql.VALUES("KOD_ZAM_1", "#{kodZam1,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam2() != null) {
            sql.VALUES("KOD_ZAM_2", "#{kodZam2,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam3() != null) {
            sql.VALUES("KOD_ZAM_3", "#{kodZam3,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String selectByExample(ZlecenieUprawnieniaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ZLECENIE_ID");
        } else {
            sql.SELECT("ZLECENIE_ID");
        }
        sql.SELECT("KOD_TYTULU_UPR");
        sql.SELECT("KOD_TYTULU_UPR_DOD");
        sql.SELECT("DATA_OD");
        sql.SELECT("DATA_DO");
        sql.SELECT("KOD");
        sql.SELECT("KOD_ZAM_1");
        sql.SELECT("KOD_ZAM_2");
        sql.SELECT("KOD_ZAM_3");
        sql.FROM("ZLECENIE_UPRAWNIENIA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZlecenieUprawnienia record = (ZlecenieUprawnienia) parameter.get("record");
        ZlecenieUprawnieniaCriteria example = (ZlecenieUprawnieniaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_UPRAWNIENIA");
        
        if (record.getZlecenieId() != null) {
            sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getKodTytuluUpr() != null) {
            sql.SET("KOD_TYTULU_UPR = #{record.kodTytuluUpr,jdbcType=VARCHAR}");
        }
        
        if (record.getKodTytuluUprDod() != null) {
            sql.SET("KOD_TYTULU_UPR_DOD = #{record.kodTytuluUprDod,jdbcType=VARCHAR}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam1() != null) {
            sql.SET("KOD_ZAM_1 = #{record.kodZam1,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam2() != null) {
            sql.SET("KOD_ZAM_2 = #{record.kodZam2,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam3() != null) {
            sql.SET("KOD_ZAM_3 = #{record.kodZam3,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_UPRAWNIENIA");
        
        sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        sql.SET("KOD_TYTULU_UPR = #{record.kodTytuluUpr,jdbcType=VARCHAR}");
        sql.SET("KOD_TYTULU_UPR_DOD = #{record.kodTytuluUprDod,jdbcType=VARCHAR}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        sql.SET("KOD_ZAM_1 = #{record.kodZam1,jdbcType=VARCHAR}");
        sql.SET("KOD_ZAM_2 = #{record.kodZam2,jdbcType=VARCHAR}");
        sql.SET("KOD_ZAM_3 = #{record.kodZam3,jdbcType=VARCHAR}");
        
        ZlecenieUprawnieniaCriteria example = (ZlecenieUprawnieniaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    public String updateByPrimaryKeySelective(ZlecenieUprawnienia record) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_UPRAWNIENIA");
        
        if (record.getKodTytuluUpr() != null) {
            sql.SET("KOD_TYTULU_UPR = #{kodTytuluUpr,jdbcType=VARCHAR}");
        }
        
        if (record.getKodTytuluUprDod() != null) {
            sql.SET("KOD_TYTULU_UPR_DOD = #{kodTytuluUprDod,jdbcType=VARCHAR}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam1() != null) {
            sql.SET("KOD_ZAM_1 = #{kodZam1,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam2() != null) {
            sql.SET("KOD_ZAM_2 = #{kodZam2,jdbcType=VARCHAR}");
        }
        
        if (record.getKodZam3() != null) {
            sql.SET("KOD_ZAM_3 = #{kodZam3,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-14 10:47:50
     */
    protected void applyWhere(SQL sql, ZlecenieUprawnieniaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}