package pl.topteam.dps.enums;

import static com.google.common.collect.FluentIterable.from;

import java.util.EnumSet;
import java.util.Set;

import pl.topteam.dps.enums.interfaces.EnumOpis;

import com.google.common.base.Function;

public enum Aktywacja implements EnumOpis {
	PAKIET_PODSTAWOWY("pakiet podstawowy (moduł socjalny)",
			EnumSet.of(GrupaUprawnien.MODUL_OGOLNY, GrupaUprawnien.MODUL_SOCJALNY,
					GrupaUprawnien.ADMINISTRACJA, GrupaUprawnien.NIEWIDOCZNE_DLA_ADMINISTRATORA)),

	PAKIET_ROZSZERZONY("pakiet rozszerzony (moduł socjalny i medyczny)",
			EnumSet.of(GrupaUprawnien.MODUL_OGOLNY, GrupaUprawnien.MODUL_SOCJALNY,
					GrupaUprawnien.MODUL_LEKI, GrupaUprawnien.MODUL_MEDYCZNY,
					GrupaUprawnien.ADMINISTRACJA, GrupaUprawnien.NIEWIDOCZNE_DLA_ADMINISTRATORA))
	;
	
	private String opis;
	private Set<GrupaUprawnien> grupyUprawnien;
	private Set<String> prefixyUprawnien;
	
	private Aktywacja(String opis, Set<GrupaUprawnien> grupyUprawnien) {
		this.opis = opis;
		this.grupyUprawnien = grupyUprawnien;
		this.prefixyUprawnien =
			from(grupyUprawnien).transform(new Function<GrupaUprawnien, String>() {
				@Override public String apply(GrupaUprawnien gu) {
					return gu.getPrzedrostek();
				}
			}).toSet();
	}
	
	public Set<GrupaUprawnien> getGrupyUprawnien() {
		return this.grupyUprawnien;
	}

	public Set<String> getPrefixyUprawnien() {
		return prefixyUprawnien;
	}

	@Override
	public String getOpis() {
		return opis;
	}
}
