package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum GrupaUprawnien implements EnumOpis {
	/**
	 * Tutaj zaliczają się wszystkie uprawnienia,
	 * niezależnie od ich przydziału w {@link Uprawnienie}.
	 */
	WSZYSTKIE("wszystkie uprawnienia", ""),
	
	/**
	 * Tutaj zaliczają się uprawnienia, które nadajemy
	 * programowo w jakiś sposób np. za pomocą triggera w bazie danych.
	 * 
	 * Na formatce definiowania uprawnień przez administratora systemu
	 * będą one niewidoczne
	 */
	NIEWIDOCZNE_DLA_ADMINISTRATORA("uprawnienia programowe", "NW_"),
	
	/**
	 * Tutaj zaliczamy uprawnienia należące do zakresu
	 * działań zarówno pracowników socjalnych ja i medycznych.
	 */
	MODUL_OGOLNY("moduł ogólny", "OG_"),
	
	/**
	 * Tutaj zaliczmy uprawnienia należące do zakresu
	 * działań w ramach modułu socjalnego programu.
	 */
	MODUL_SOCJALNY("moduł socjalny", "SOC_"),
	
	/**
	 * Tutaj zaliczmy uprawnienia należące do zakresu
	 * działań w ramach modułu magazynowego leków.
	 */
	MODUL_LEKI("moduł leki", "LK_"),
	
	/**
	 * Tutaj zaliczmy uprawnienia należące do zakresu
	 * działań w ramach modułu medycznego programu.
	 */
	MODUL_MEDYCZNY("moduł medyczny", "MED_"),

	/**
	 * Tutaj zaliczymy uprawnienia należące do zakresu
	 * działań w ramach administacji programem.
	 */
	ADMINISTRACJA("moduł administracyjny", "ADM_")
	;
	
	private String opis;
	private String przedrostek;
	
	private GrupaUprawnien(String opis, String przedrostek) {
		this.opis = opis;
		this.przedrostek = przedrostek;
	}

	@Override
	public String getOpis() {
		return opis;
	}

	public String getPrzedrostek() {
		return przedrostek;
	}

	public void setPrzedrostek(String przedrostek) {
		this.przedrostek = przedrostek;
	}
}
