package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum JednostkaMiary implements EnumOpis {
	POLSKI_ZLOTY("polski złoty", "zł", TypLiczby.DOUBLE),

	DIOPTRIA("dioptria", "dptr", TypLiczby.DOUBLE),
	HEKTOLITR("hektolitr", "hl", TypLiczby.DOUBLE),
	KILOGRAM("kilogram", "kg", TypLiczby.DOUBLE),
	LITR("litr", "l", TypLiczby.DOUBLE),
	MILIGRAM_DECYLITR("miligram na decylitr", "mg/dl", TypLiczby.DOUBLE),
	MILIMETR_HG("milimetr słupka rtęci", "mmHg", TypLiczby.DOUBLE),
	PROMIL("promil", "&#8240;", TypLiczby.DOUBLE), //‰
	STOPIEN_CELSJUSZA("stopień Celsjusza", "&#176;C", TypLiczby.DOUBLE),
	SZTUKA("sztuka", "szt.", TypLiczby.INTEGER),
	TONA("tona", "t", TypLiczby.DOUBLE)
	;

	private String opis;
	private String skrot;
	private TypLiczby typLiczby;

	private JednostkaMiary(String opis, String skrot, TypLiczby typLiczby) {
		this.opis = opis;
		this.skrot = skrot;
		this.typLiczby = typLiczby;
	}

	public String getSkrot() {
		return this.skrot;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}

	public TypLiczby getTypLiczby() {
		return this.typLiczby;
	}
}
