package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;
import pl.topteam.enums.interfaces.CSVLabel;

public enum NazwaPolaCSV implements CSVLabel, EnumOpis {
	DATA_TRANSAKCJI("data transakcji"),
	DANE_MIESZKANCA("dane mieszkańca"),
	IBAN("numer konta bankowego (IBAN)"),
	KWOTA_GR("kwota (w groszach)"),
	KWOTA_ZL("kwota (w zł)"),
	MIESZKANIEC_ID("mieszkaniec ID (TT DPS)"),
	PODMIOT_WPLACAJACY("podmiot wpłacający"),
	TYP_OPERACJI("typ operacji")
	;
	
	private String opis;
	
	private NazwaPolaCSV(String opis) {
		this.opis = opis;
	}
	
	@Override
	public Integer getKolejnosc() {
		return null;
	}
	
	@Override
	public String getCSVLabel() {
		return getName();
	}
	
	public String getName() {
		return this.name();
	}
	
	@Override
	public String getOpis() {
		return opis;
	}
	
	@Override
	public String toString() {
		return super.name();
	}
}
