package pl.topteam.dps.enums;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum NazwySlownikow implements EnumOpis {
	KOD_CHARAKTERU_WIZYTY_LEKARZA("Charakter wizyty lekarza", "kodCharakteruWizytyLekarzaSlownik"),
	KOD_DODATKU_POBIERANEGO_SWIADCZENIA("Dodatek dla pobieranego świadczenia", "kodDodatkuPobieranegoSwiadczeniaSlownik"),
	KOD_LEKARZA("Lekarz", "kodLekarzaSlownik"),
	KOD_MIEJSCA_PRZYJSCIA_DO_DPS("Miejsce przyjścia do DPS", "kodMiejscaPrzyjsciaDoDPSSlownik"),
	KOD_MIEJSCA_ODEJSCIA_Z_DPS("Miejsce odejścia z DPSu", "kodMiejscaOdejsciaZDPSuSlownik"),
	KOD_MIEJSCA_ZGONU("Miejsce zgonu osoby", "kodMiejscaZgonuSlownik"),
	KOD_NIEDOMAGANIA_MIESZKANCA("Niedomagania pacjenta (kwalifikacja pielęgniarska)", "kodNiedomaganiaPacjentaSlownik"),
	KOD_OBIEKTU_MONITOROWANIA("Przedmiot monitorowania mieszkańca", "kodObiektuMonitorowaniaSlownik"),
	KOD_OBYWATELSTWA("Obywatelstwo", "kodObywatelstwaSlownik") {
		@Override
		public RodzajSlownika getRodzajSlownika() {
			return RodzajSlownika.NIEEDYTOWALNY;
		}
	},
	KOD_ORGANU_DAROWIZNA_LEKOW("Organ przekazujący leki w darze", "kodOrganuDarowiznaLekowSlownik"),
	KOD_ORGANU_ODP_POGRZEB("Oragan odpowiedzialny za pochówek osób", "kodOrganuOdpPogrzeb"),
	KOD_ORGANU_SCIGANIA("Organ ściagnia", "kodOrganuSciganiaSlownik"),
	KOD_ORGANU_WYDAJACEGO_DEC_KIERUJACA("Organ wydający decyzję kierującą", "kodOrgWydajacyDecKierujacaSlownik"),
	KOD_ORGANU_WYDAJACEGO_DEC_ODPLATNOSC("Organ wydający decyzję o alimentacji/odpłatności", "kodOrgWydajacyDecOOdplatnosciSlownik"),
	KOD_ORGANU_WYDAJACEGO_DEC_UMIESZCZAJACA("Organ wydający decyzję umieszczającą", "kodOrgWydajacyDecUmieszczajaceSlownik"),
	KOD_ORGANU_WYDAJACEGO_DOWOD_OS("Organ wydający dowód osobisty", "kodOrganuWydDowodOsSlownik"),
	KOD_ORGANU_WYDAJACEGO_ORZ_NIEPEL("Organ wydający orzeczenie o niepełnosprawności", "kodOrganuWydOrzeczNiepelSlownik"),
	KOD_PODMIOTU_ODBIOR_ODPADOW("Podmiot odbierający odpady medyczne", "kodPodmiotuOdbiorOdpadowSlownik"),
	KOD_POWODU_WIZYTY_LEKARZA("Powód wizyty lekarza", "kodPowoduWizytyLekarzaSlownik"),
	KOD_PRACOWNIKA_PK("Pracownik PK", "kodPracownikaPKSlownik"),
	KOD_RODZAJU_DIAGNOZY("Rodzaj wystawianej diagnozy", "kodRodzajuWystawianejDiagnozySlownik"),
	KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO("Rodzaju dyżuru pielęgniarskiego", "kodRodzajuDyzuruPielegniarskiegoSlownik") {
		@Override
		public RodzajSlownika getRodzajSlownika() {
			return RodzajSlownika.NIEEDYTOWALNY;
		}
	},
	KOD_RODZAJU_KWOTY_UMOWA_APTEKA("Rodzaj kwoty na umowie z apteką", "kodRodzajuKwotyAptekaSlownik"),
	KOD_RODZAJU_MATERIALU_BADANIA("Rodzaj materiału pobranego do badań", "kodRodzajuMaterialuBadaniaSlownik"),
	KOD_RODZAJU_NIEOBECNOSCI("Rodzaj nieobecności mieszkańca", "kodRodzajuNieobecnosciSlownik"),
	KOD_RODZAJU_ODPADU_MEDYCZNEGO("Rodzaj odpadu medycznego", "kodRodzajuOdpaduMedycznegoSlownik"),
	KOD_RODZAJU_POSTANOWIENIA_SADU("Rodzaj postanowienia sądu", "kodRodzajuPostanowieniaSaduSlownik"),
	KOD_RODZAJU_ZAPOMOGI("Rodzaj zapomogi", "kodRodzajuZapomogiSlownik"),
	KOD_STANU_CYWILNEGO("Stan cywilny", "kodStanuCywilnegoSlownik") {
		@Override
		public RodzajSlownika getRodzajSlownika() {
			return RodzajSlownika.NIEEDYTOWALNY;
		}
	},
	KOD_STANU_ZDROWIA("Stan zdrowia", "kodStanuZdrowiaSlownik"),
	KOD_STOPNIA_NIEPELNOSPRAWNOSCI("Stopień niepełnosprawności", "kodStopniaNiepelnosprawnosciSlownik") {
		@Override
		public RodzajSlownika getRodzajSlownika() {
			return RodzajSlownika.NIEEDYTOWALNY;
		}
	},
	KOD_STOPNIA_POKREWIENSTWA("Stopień pokrewieństwa", "kodStopniaPokrewienstwaSlownik"),
	KOD_TYTULU_UPRAWNIENIA("Tytuł uprawnienia (wyroby medyczne)", "kodTytuluUprawnieniaSlownik") {
		@Override
		public RodzajSlownika getRodzajSlownika() {
			return RodzajSlownika.NIEEDYTOWALNY;
		}
	},
	KOD_TYTULU_UPRAWNIENIA_DODATKOWEGO("Tytuł uprawnienia dodatkowego  (wyroby medyczne)", "kodTytuluUprawnieniaDodatkowegoSlownik") {
		@Override
		public RodzajSlownika getRodzajSlownika() {
			return RodzajSlownika.NIEEDYTOWALNY;
		}
	},
	KOD_USC("USC", "kodUSCSlownik"),
	KOD_WYZNANIA("Wyznanie", "kodWyznaniaSlownik"),
	KOD_WYKSZTALCENIA("Wykształcenie", "kodWyksztalceniaSlownik"),
	KOD_ZAKRESU_POSTANOWIENIA_SADU("Zakres postanowienia sądowego", "kodZakresuPostanowienia")
	;

	//sprawdzanie czy nazwy słowników przechowywanych w context'cie są unikalne
	static {
		List<String> listaNazw = new ArrayList<>();

		for(NazwySlownikow nazwaSlownika : NazwySlownikow.values()) {
			if(StringUtils.isNotEmpty(nazwaSlownika.getNazwaServerContext())) {
				if(listaNazw.contains(nazwaSlownika.getNazwaServerContext())) {
					throw new IllegalArgumentException("Klucze słowników przechowywane w context'cie są powielone: " + nazwaSlownika.getNazwaServerContext());
				}

				listaNazw.add(nazwaSlownika.getNazwaServerContext());
			}

			if(nazwaSlownika.getRodzajSlownika() == null) {
				throw new IllegalArgumentException("Rodzaj słownika jest wymagany dla " + nazwaSlownika);
			}

			if(nazwaSlownika.getTypSlownika() == null) {
				throw new IllegalArgumentException("Typ słownika jest wymagany dla " + nazwaSlownika);
			}
		}
	}

	private String nazwaServerContext;
	private String opis;

	private NazwySlownikow(String opis, String nazwaServerContext) {
		this.nazwaServerContext = nazwaServerContext;
		this.opis = opis;
	}

	public RodzajSlownika getRodzajSlownika() {
		return RodzajSlownika.EDYTOWALNY;
	}

	public TypSlownika getTypSlownika() {
		return TypSlownika.WART_S;
	}

	public String getNazwaServerContext() {
		return nazwaServerContext;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
