package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

/**
 * Czy pobierane świadczenie trafia do DPSu i są najpierw rozliczane dopłaty, zwroty do pobytu
 * czy może trafia do rąk mieszkańca i wówczas DPS musi sam odzyskać od niej te pieniądze.
 */
public enum RodzajOdbioruSwiadczenia implements EnumOpis {
	DPS("odbiór przez DPS"),
	MIESZKANIEC("odbiór przez mieszkańca")
	;
	
	private String opis;
	
	private RodzajOdbioruSwiadczenia(String opis) {
		this.opis = opis;
	}
	
	@Override
	public String getOpis() {
		return this.opis;
	}
}
