package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum StatusDoliczeniePobyt implements EnumOpis {
	/** Nowoobliczone doliczenie */
	NOWE("nowe"),
	/** Z tego doliczenia zostało wprowadzone naliczenie */
	NALICZONE("naliczone"),
	/** Zrealizowane np. poza tym programem. Kwota powinna być uwzględniana przy obliczaniu kolejnych doliczeń. */
	ZREALIZOWANE("zrealizowane")
	;

	private String opis;

	private StatusDoliczeniePobyt(String opis) {
		this.opis = opis;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
