package pl.topteam.dps.enums;

import java.util.EnumSet;
import java.util.Set;

import pl.topteam.dps.enums.interfaces.EnumOpis;
import pl.topteam.dps.enums.sm.EnumStateMachine;

public enum StatusTypuInformacjiDodatkowej
		implements EnumOpis, EnumStateMachine<StatusTypuInformacjiDodatkowej> {
	DEFINICJA("informacja zdefiniowana"){
		@Override
		public Set<StatusTypuInformacjiDodatkowej> getTransitions() {
			return EnumSet.of(DEFINICJA, DEFINICJA_I_WPROWADZANIE);
		}
	},
	DEFINICJA_I_WPROWADZANIE("informacja przeznaczona do wprowadzania przez użytkowników"){
		@Override
		public Set<StatusTypuInformacjiDodatkowej> getTransitions() {
			return EnumSet.of(DEFINICJA_I_WPROWADZANIE);
		}
	},
	/** Ten stan jest automatycznie ustawiany i nie powinno być możliwości ręcznego ustawienia */
	DEFINICJA_ZABLOKOWANA("informacja została wprowadzona (edycja jest zablokowana)") {
		@Override
		public Set<StatusTypuInformacjiDodatkowej> getTransitions() {
			return EnumSet.of(DEFINICJA_ZABLOKOWANA);
		}
	}
	;

	/**
	 * Statusy informacji dodatkowych, dla których dozwolone jest
	 * wprowadzanie wpisów dla osób oczekujących bądź zamieszkujących
	 * DPS.
	 */
	public static StatusTypuInformacjiDodatkowej[] PRZEZNACZONE_DO_WPROWADZANIA = {
		DEFINICJA_I_WPROWADZANIE,
		DEFINICJA_ZABLOKOWANA
	};

	private String opis;

	private StatusTypuInformacjiDodatkowej(String opis) {
		this.opis = opis;
	}

	@Override
	public Set<StatusTypuInformacjiDodatkowej> getTransitions() {
		return EnumSet.allOf(StatusTypuInformacjiDodatkowej.class);
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
