package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum StatusWyrownania implements EnumOpis {
	/**
	 * Do rozpatrzenia czy w rozliczeniach ma być wliczane w dług czy nie - status zamknięte.
	 *
	 * W_REALIZACJI <----> ZAMKNIETE (dowolne transformacje)
	 */
	W_REALIZACJI("w realizacji"),
	/**
	 * Nie wliczane do długu (pole kwota pozostaje nie uwzględniane w długu)
	 *
	 * W_REALIZACJI <----> ZAMKNIETE (dowolne transformacje)
	 */
	ZAMKNIETE("zamknięte"),

	/**
	 * Wliczone w całości w dług tak jak pozostałe składniki (pole kwota)
	 * (automat - rozliczający może tylko ustawić ten status); status nie podlega zmianom przez użytkownika
	 */
	WLICZONE("wliczone")
	;

	private String opis;

	private StatusWyrownania(String opis) {
		this.opis = opis;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
