package pl.topteam.dps.enums;

import java.util.EnumSet;
import java.util.Set;

import pl.topteam.dps.enums.interfaces.EnumOpis;

/*
 * !!! UWAGA !!!
 * Po wprowadzeniu nowego enuma należy go wprowadzić również do metody
 * przekierujOczekujacyMieszkaniec().
 * 
 * Ponadto należy trzymać się konwencji nalewniczej:
 * OSOBA_OCZEKUJACA_??? - wpis dotyczy osób oczekujących
 * MIESZKANIEC_??? - wpis dotyczy mieszkańca
 */
public enum TypEwidencji implements EnumOpis {
	OSOBA_OCZEKUJACA(
			EnumSet.of(Branch.DOM_POMOCY, Branch.MIESZKANIA_CHRONIONE), "oczekujący"),
	OSOBA_OCZEKUJACA_REZYGNACJA(
			EnumSet.of(Branch.DOM_POMOCY, Branch.MIESZKANIA_CHRONIONE), "oczekujący (rezygnacja)"),
	OSOBA_OCZEKUJACA_ZGON(
			EnumSet.of(Branch.DOM_POMOCY, Branch.MIESZKANIA_CHRONIONE), "oczekujący (zgon)"),
	
	MIESZKANIEC(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.OSRODEK_OPIEKUNCZY, Branch.MIESZKANIA_CHRONIONE), "mieszkaniec"),
	MIESZKANIEC_REZYGNACJA(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.OSRODEK_OPIEKUNCZY, Branch.MIESZKANIA_CHRONIONE), "mieszkaniec (rezygnacja)"),
	MIESZKANIEC_WYPROWADZKA(
			EnumSet.of(Branch.DOM_POMOCY, Branch.MIESZKANIA_CHRONIONE), "mieszkaniec (wyprowadzka)"),
	MIESZKANIEC_ZGON(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.OSRODEK_OPIEKUNCZY, Branch.MIESZKANIA_CHRONIONE), "mieszkaniec (zgon)")
	;

	private Set<Branch> branch;
	private String opis;
	
	private TypEwidencji(Set<Branch> branch, String opis) {
		this.branch = branch;
		this.opis = opis;
	}
	
	public Set<Branch> getBranch() {
		return branch;
	}

	@Override
	public String getOpis() {
		return opis;
	}
	
	public static Set<TypEwidencji> getTypyEwidencjiOsobyOczekujacej() {
		return EnumSet.of(OSOBA_OCZEKUJACA, OSOBA_OCZEKUJACA_REZYGNACJA, OSOBA_OCZEKUJACA_ZGON);
	}
	
	public static Set<TypEwidencji> getTypyEwidencjiMieszkanca() {
		return EnumSet.of(MIESZKANIEC, MIESZKANIEC_REZYGNACJA, MIESZKANIEC_WYPROWADZKA, MIESZKANIEC_ZGON);
	}
}
