package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypMagazynu implements EnumOpis {
	/**
	 * Magazyn leków kupiowanych na recepty. Operacje przeprowadzane
	 * na nim uwzględniać mają wpis ewidencyjny.
	 */
	LEKI("magazyn leków"),
	/**
	 * Magazyn leków doraźnych stanowi podręczną apteczkę leków,
	 * wydawanych co prawda dla poszczególnych mieszkańców,
	 * ale nie kupowanych z przeznaczeniem dla nich.
	 */
	LEKI_DORAZNE("magazyn leków doraźnych"),
	/**
	 * Magazyn wyrobów medycznych
	 */
	WYROBY_MEDYCZNE("magazyn wyrobów medycznych")
	;

	private String opis;

	private TypMagazynu(String opis) {
		this.opis = opis;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
