package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypOperacji implements EnumOpis {
// autonumeracja
	AUTONUMERACJA_AKTUALIZACJA("autonumeracja (aktualizacja)"),

// czas pracy lampy UV
	CZAS_PRACY_UV_DODAWANIE_AKTUALIZACJA("czas pracy lampy UV (dodawanie/aktualizacja)"),
	CZAS_PRACY_UV_USUNIECIE("czas pracy lampy UV (usunięcie)"),

// członek rodziny
	CZL_R_DODAWANIE_AKTUALIZACJA("członek rodziny (dodawanie/aktualizacja)"),
	CZL_R_USUNIECIE("członek rodziny (usunięcie)"),

// dane DPSu
	DANE_DPS_AKTUALIZACJA("dane DPS (aktualizacja)"),

// dane DPSu - ewidencja pokoi
	DANE_DPS_EW_POKOI_DODAWANIE("dane DPS - ewidencja pokoi (dodawanie)"),
	DANE_DPS_EW_POKOI_SZYBKIE_DODAWANIE("dane DPS - ewidencja pokoi (dodawanie)"),

	DANE_DPS_EW_POKOI_INDYWID_DODAWANIE("ewidencja pokoi (dodawanie)"),
	DANE_DPS_EW_POKOI_AKTUALIZACJA("ewidencja pokoi (aktualizacja)"),
	DANE_DPS_EW_POKOI_USUNIECIE("ewidencja pokoi (usunięcie)"),

// dawkowanie leków
	DAWKOWANIE_DODAWANIE("dawkowanie leków (dodawanie)"),
	DAWKOWANIE_AKTUALIZACJA("dawkowanie leków (aktualizacja)"),
	DAWKOWANIE_USUNIECIE("dawkowanie leków (usunięcie)"),

// decyzja kierująca
	DEC_KIER_DODAWANIE("decyzja kierująca (dodawanie)"),
	DEC_KIER_AKTUALIZACJA("decyzja kierująca (aktualizacja)"),
	DEC_KIER_USUNIECIE("decyzja kierująca (usunięcie)"),

// decyzja o alimentacji
	DEC_ALIM_DODAWANIE("decyzja o alimentacji (dodawanie)"),
	DEC_ALIM_AKTAULIZACJA("decyzja o alimentacji (aktualizacja)"),
	DEC_ALIM_USUNIECIE("decyzja o alimentacji (usunięcie)"),

// decyzja o odpłatności
	DEC_ODPL_DODAWANIE("decyzja o odpłatności (dodawanie)"),
	DEC_ODPL_DODAWANIE_AKTUALIZACJA("decyzja o odpłatności (dodawanie/aktualizacja)"),
	DEC_ODPL_DODAWANIE_PROJEKT("decyzja o odpłatności (dodawanie - projekt)"),
	DEC_ODPL_AKTAULIZACJA("decyzja o odpłatności (aktualizacja)"),
	DEC_ODPL_USUNIECIE("decyzja o odpłatności (usunięcie)"),

// decyzja umieszczająca
	DEC_UM_DODAWANIE_AKTUALIZACJA("decyzja ummieszczająca (dodawanie/aktualizacja)"),
	DEC_UM_USUNIECIE("decyzja umieszczająca (usunięcie)"),

// decyzja uchylająca
	DEC_UCH_DODAWANIE("decyzja uchylająca (dodawanie)"),
	DEC_UCH_AKTUALIZACJA("decyzja uchylająca (aktualizacja)"),
	DEC_UCH_USUNIECIE("decyzja uchylająca (usunięcie)"),

// decyzja wygaszajaca
	DEC_WYG_DODAWANIE("decyzja wygaszająca (dodawanie)"),
	DEC_WYG_AKTUALIZACJA("decyzja wygaszająca (aktualizacja)"),
	DEC_WYG_USUNIECIE("decyzja wygaszająca (usunięcie)"),

// dopłata limit
	DOPLATA_LIMIT_DODAWANIE_AKTUALIZACJA("dopłata - wys. limitu (dodawanie/aktualizacja)"),
	DOPLATA_LIMIT_USUNIECIE("dopłata - wys. limitu (usunięcie)"),

// dowód osobisty
	DWD_OS_DODAWANIE_AKTUALIZACJA("dowód osobisty (dodawanie/aktualizacja)"),
	DWD_OS_USUNIECIE("dowód osobisty (usunięcie)"),

// doliczenie do naliczeń za pobyt
	DOLICZENIE_AKTUALIZACJA("doliczenie (aktualizacja)"),

// ewidencje (mieszkańca, osoby oczekującej, oraz usunięcie wpisu ewidencyjnego)
	EWID_M_REJ_NOWEGO("ewidencja mieszkańca (rejestracja)"),
	EWID_M_REJ_NOWEGO_AKTUALIZACJA("ewidencja mieszkańca (aktualizacja)"),
	EWID_M_REJ_PONOWNA_DODAWANIE_AKTUALIZACJA("ewidencja mieszkańca (ponowna rejestracja)"),
	EWID_M_REZYGNACJA_DODAWANIE_AKTUALIZACJA("ewidencja rezygnacji mieszkańca (dodawanie/aktualizacja)"),
	EWID_M_WYPROWADZKA_DODAWANIE_AKTUALIZACJA("ewidencja wyprowadzki mieszkańca (dodawanie/aktualizacja)"),
	EWID_M_ZGON_DODAWANIE_AKTUALIZACJA("ewidencja zgonu mieszkańca (dodawanie/aktualizacja)"),

	EWID_USUNIECIE("ewidencja (usunięcie)"),

	EWID_O_REJ_NOWEGO("ewidencja os. oczekującej (rejestracja)"),
	EWID_O_REJ_NOWEGO_AKTUALIZACJA("ewidencja os. oczekującej (aktualizacja)"),
	EWID_O_REJ_PONOWNA_DODAWANIE_AKTUALIZACJA("ewidencja os. oczekującej (ponowna rejestracja)"),
	EWID_O_REZYGNACJA_DODAWANIE_AKTUALIZACJA("ewidencja rezygnacji os. oczekującej (dodawanie/aktualizacja)"),
	EWID_O_ZGON_DODAWANIE_AKTUALIZACJA("ewidencja zgonu os. oczekującej (dodawanie/aktualizacja)"),

	EWID_O_PRZEKSZT_M("ewidencja mieszkańca (przekształcenie z os. oczekującej)"),

// faktura VAT
	FAKTURA_USUNIECIE("faktura VAT (usunięcie)"),

// format plików importu
	FORMAT_PLIKOW_DODAWANIE_AKTUALIZACJA("format plików (dodawanie/aktualizacja)"),
	FORMAT_PLIKOW_USUNIECIE("format plików (usunięcie)"),

// informacja dodatkowa (definicja)
	INFOR_DOD_DEF_DODAWANIE(" def. informacji dodatkowej (dodawanie)"),
	INFOR_DOD_DEF_AKTUALIZACJA(" def. informacji dodatkowej (aktualizacja)"),
	INFOR_DOD_DEF_USUNIECIE("def. informacji dodatkowej (usunięcie)"),

// informacja dodatkowa (realizacja)
	INFOR_DOD_REAL_DODAWANIE("informacja dodatkowa (dodawanie)"),
	INFOR_DOD_REAL_AKTUALIZACJA("informacja dodatkowa (aktualizacja)"),
	INFOR_DOD_REAL_USUNIECIE("informacja dodatkowa (usunięcie)"),

// instytucja dopłacająca do utrzymania mieszkańca
	INSTYTUCJA_DOPL_DODAWANIE_AKTUALIZACJA("instytucja dopłacająca do utrzymania mieszkańca (dodawanie/aktualizacja)"),
	INSTYTUCJA_DOPL_USUWANIE("instytucja dopłacająca do utrzymania mieszkańca (usuwanie)"),

// interwencja organów ścigania
	INTERWENCJA_ORG_SCI_DODAWANIE_AKTUALIZACJA("interwencja organów ścigania (dodawanie/aktualizacja)"),
	INTERWENCJA_ORG_SCI_USUNIECIE("interwencja organów ścigania (usunięcie)"),

// interwencja organów ścigania
	INTERWENCJA_POG_RAT_DODAWANIE_AKTUALIZACJA("interwencja pogotowia ratunkowego (dodawanie/aktualizacja)"),
	INTERWENCJA_POG_RAT_USUNIECIE("interwencja pogotowia ratunkowego (usunięcie)"),

// katalog usług
	KAT_USL_KATEGORIA_DODAWANIE("kategoria usług (dodawanie)"),
	KAT_USL_KATEGORIA_AKTUALIZACJA("kategoria usług (usunięcie)"),
	KAT_USL_KATEGORIA_USUNIECIE("kategoria usług (usunięcie)"),
	KAT_USL_CZYNNOSC_DODAWANIE("czynność kat. usług (dodawanie)"),
	KAT_USL_CZYNNOSC_AKTUALIZACJA("czynność kat. usług (usunięcie)"),
	KAT_USL_CZYNNOSC_USUNIECIE("czynność kat. usług (usunięcie)"),

// konto bankowe
	KONTO_BANKOWE_DODAWANIE_AKTUALIZACJA("konto bankowe (dodawanie/aktualizacja)"),
	KONTO_BANKOWE_USUNIECIE("konto bankowe (usunięcie)"),

// kopia bazy danych
	KOPIA_BAZY_TWORZENIE("tworzenie kopii bazy danych"),

// kwalifikacja pielęgniarska
	KWALIFIKACJA_PIEL_DODAWANIE_AKTUALIZACJA("kwalifikacja pielęgniarska (dodawanie/aktualizacja)"),
	KWALIFIKACJA_PIEL_USUNIECIE("kwalifikacja pielęgniarska (usunięcie)"),

// meldunek
	MELDUNEK_DODAWANIE_AKTUALIZACJA("meldunek czasowy (dodawanie/aktualizacja"),
	MELDUNEK_USUWANIE("meldunek czasowy (usuwanie)"),

// magazyn leków doraźnych
	MG_LK_DORAZNE_DODAWANIE_AKTUALIZACJA("wpis w magazynie leków doraźnych (dodawanie/aktualizacja)"),
	MG_LK_DORAZNE_USUNIECIE("wpis w magazynie leków doraźnych (usunięcie)"),

// magazyn leków doraźnych
	MG_LK_PODRECZNE_DODAWANIE_AKTUALIZACJA("wpis w magazynie leków podręcznych (dodawanie/aktualizacja)"),
	MG_LK_PODRECZNE_USUNIECIE("wpis w magazynie leków podręcznych (usunięcie)"),

// miejsce pobytu/skierowania mieszkańca
	MIEJSCE_POBYTU_DODAWANIE_AKTUALIZACJA("miejsce pobytu/skierowania osoby (dodawanie/aktualizacja)"),
	MIEJSCE_POBYTU_USUNIECIE("miejsce pobytu/skierowania osoby (dodawanie/aktualizacja)"),

// mieszkaniec (osoba)
	MIESZKANIEC_AKTUALIZACJA("mieszkaniec (aktualizacja danych osobowych)"),
	MIESZKANIEC_USUNIECIE("mieszkaniec (usunięcie)"),
	MIESZKANIEC_PRZYPISANIE("mieszkaniec (przypisanie pracownika)"),

// monitorowanie mieszkańców
	MONITOROWANIE_DODAWANIE_AKTUALIZACJA("monitorowanie (dodawanie/aktualizacja)"),
	MONITOROWANIE_USUNIECIE("monitorowanie (usunięcie)"),

//grupa
	GRUPA_PRACOWNIKOW_DODAWANIE("grupa pracowników (dodawanie)"),
	GRUPA_PRACOWNIKOW_AKTUALIZACJA("grupa pracowników (aktualizacja)"),
	GRUPA_PRACOWNIKOW_USUNIECIE("grupa pracowników (usunięcie)"),

// nieobecności
	NIEOB_DODAWANIE("nieobecność (dodawanie)"),
	NIEOB_AKTUALIZACJA("nieobecność (aktualizacja)"),
	NIEOB_USUNIECIE("nieobecność (usunięcie)"),

// naliczenie za pobyt (pozycja)
	NALICZENIE_POZYCJA("naliczanie płatności - pozycja (dodawanie/aktualizacja)"),

// nota odpłatności
	NOTA_ODPLATNOSC_DODAWANIE_AKTUALIZACJA("nota dla odpłatności (dodawanie/aktualizacja)"),
	NOTA_ODPLATNOSC_USUNIECIE("nota dla odpłatności (usunięcie)"),

// ocena mieszkańca wg skali
	OCENA_WG_SKALI_DODAWANIE_AKTUALIZACJA("ocena mieszkańca wg skali (dodawanie/aktualizacja)"),
	OCENA_WG_SKALI_USUNIECIE("ocena mieszkańca wg skali (usunięcie)"),

// odpady medyczne
	ODPADY_MEDYCZNE_DODAWANIE_AKTUALIZACJA("odpady medyczne (dodawanie/aktualizacja)"),
	ODPADY_MEDYCZNE_USUNIECIE("odpady medyczne (usunięcie)"),

// odpis za nieobecność
	ODPIS_DODAWANIE_AKTUALIZACJA("odpis (dodawanie/aktualizacja)"),
	ODPIS_DODAWANIE_NIEOB("odpis za nieobecność (dodawanie z podp.)"),
	ODPIS_USUNIECIE("odpis za nieobecność (usunięcie)"),

// odwiedziny mieszkańca
	ODWIEDZINY_DODAWANIE_AKTUALIZACJA("odwiedziny (dodawanie/aktualizacja)"),
	ODWIEDZINY_USUNIECIE("odwiedziny (usunięcie)"),

// postanowienie sądu
	POSTANOWIENIE_SADU_DODAWANIE_AKTUALIZACJA("postanowienie sądu (dodawanie/aktualizacja)"),
	POSTANOWIENIE_SADU_USUNIECIE("postanowienie sądu (usunięcie)"),

// osoba oczekująca
	OS_OCZEK_AKTUALIZACJA("osoba oczekująca (aktualizacja danych)"),
	OS_OCZEK_USUNIECIE("osoba oczekująca (usunięcie)"),

// wyliczanie odpłatności
	ODPL_DODAWANIE("odpłatność (wyliczenie)"),
	ODPL_AKTUALIZACJA("odpłatność (aktualizacja)"),
	ODPL_USUNIECIE("odpłatność (usunięcie)"),

// orzeczenie o niepełnosprawności
	ORZECZ_NIEP_DODAWANIE_AKTUALIZACJA("orzeczenie o niepełnosprawności (dodawanie/aktualizacja)"),
	ORZECZ_NIEP_USUNIECIE("orzeczenie o niepełnosprawności (usunięcie)"),

// parametr systemowy
	PARAM_SYS_DODAWANIE("parametr systemowy(dodawanie)"),
	PARAM_SYS_ZOBOWALIM_DODAWANIE_AKTUALIZACJA("parametr systemowy - osoby zobowiązany alimentacja - (dodawanie/aktualizacja)"),
	PARAM_SYS_KOLSPL_DODAWANIE_AKTUALIZACJA("parametr systemowy - kolejność spłat - (dodawanie/aktualizacja)"),
	PARAM_SYS_OBSL_OKR_DODAWANIE_AKTUALIZACJA("parametr systemowy - obsługa okresów - (dodawanie/aktualizacja)"),
	PARAM_SYS_AKTUALIZACJA("parametr systemowy(aktualizacja)"),
	PARAM_SYS_USUNIECIE("parametr systemowy(usunięcie)"),

// plan wsparcia mieszkańca
	PLAN_WSPARCIA_MIESZKANCA_DODAWANIE("indywidualny plan wsparcia mieszkańca (dodawanie)"),
	PLAN_WSPARCIA_MIESZKANCA_AKTUALIZACJA("indywidualny plan wsparcia mieszkańca (aktualizacja)"),
	PLAN_WSPARCIA_MIESZKANCA_USUNIECIE("indywidualny plan wsparcia mieszkańca (usunięcie)"),

// plan wsparcia (realizacja)
	PLAN_WSPARCIA_REAL_DODAWANIE_AKTUALIZACJA("realizacja planu wsparcia (dodawanie/aktualizacja)"),
	PLAN_WSPARCIA_REAL_DODAWANIE_AKTUALIZACJA_SZYBKA("realizacja planu wsparcia (dodawanie/aktualizacja)"),
	PLAN_WSPARCIA_CZYNN_USUNIECIE("realizacja planu wsparcia (usunięcie czynności)"),

// płatność (naliczanie indywidualne)
	PLATNOSC_DODAWANIE("naliczanie płatności (dodawanie)"),
	PLATNOSC_DODAWANIE_ZBIORCZE("naliczanie płatności (dodawanie)"),
	@Deprecated // pozostało tylko w dzienniku do wglądu osób
	PLATNOSC_AKTUALIZACJA("naliczanie płatności (aktualizacja)"),
	PLATNOSC_USUNIECIE("naliczanie płatności (usunięcie)"),

// plik CSV (importy)
	PLIK_CSV_DODAWANIE("plik CSV (dodawanie)"),
	PLIK_CSV_USUNIECIE("plik CSV (usunięcie)"),

// pobierane świadczenie
	POB_SWIAD_DODAWANIE_AKTUALIZACJA("pobierane świadczenie (dodawanie/aktualizacja)"),
	POB_SWIAD_USUNIECIE("pobierane świadczenie (usunięcie)"),

// pobranie krwi
	POB_MATERIAL_BADANIA_DODAWANIE_AKTUALIZACJA("pobranie krwi do badań (dodawanie/aktualizacja)"),
	POB_MATERIAL_BADANIA_USUNIECIE("pobranie krwi do badań (usunięcie)"),

// polityka bezpieczeństwa
	POLITYKA_BEZPIECZENSTWA_AKTUALIZACJA("polityka bezpieczeństwa (aktualizacja)"),

// pomiar alkomatem
	POMIAR_ALKOMATEM_DODAWANIE_AKTUALIZACJA("pomiar alkomatem (dodawanie/aktualizacja)"),
	POMIAR_ALKOMATEM_USUNIECIE("pomiar alkomatem (usunięcie)"),

// pomiar temperatury ciała
	POMIAR_CISN_TETN_DODAWANIE_AKTUALIZACJA("pomiar ciśnienia tętniczego (dodawanie/aktualizacja)"),
	POMIAR_CISN_TETN_USUNIECIE("pomiar ciśnienia tętniczego (usunięcie)"),

// pomiar glikemii
	POMIAR_GLIKEMII_DODAWANIE_AKTUALIZACJA("pomiar glikemii (dodawanie/aktualizacja)"),
	POMIAR_GLIKEMII_USUNIECIE("pomiar glikemii (usunięcie)"),

// pomiar temperatury ciała
	POMIAR_TEMP_CIALA_DODAWANIE_AKTUALIZACJA("pomiar temperatury ciała (dodawanie/aktualizacja)"),
	POMIAR_TEMP_CIALA_USUNIECIE("pomiar temperatury ciała (usunięcie)"),

// pora dnia podawania leków
	PORA_DNIA_DODAWANIE_AKTUALIZACJA("pora dnia podawania leków (dodawanie/aktualizacja)"),
	PORA_DNIA_USUNIECIE("pora dnia podawania leków (usunięcie)"),

// pracownik
	PRACOWNIK_DODAWANIE("pracownik (dodawanie)"),
	PRACOWNIK_AKTUALIZACJA("pracownik (aktualizacja)"),
	PRACOWNIK_USUNIECIE("pracownik (usunięcie)"),

// pracownik - wymuszona zmiana hasła
	PRACOWNIK_BLEDNE_LOGOWANIE("pracownik - błędne logowanie"),
	PRACOWNIK_LOGOWANIE("pracownik - logowanie do systemu"),
	PRACOWNIK_WYM_ZMIANA_HASLA("pracownik - wymuszenie zmiany hasła"),

// przelew druk
	PRZELEW_DRUK_DODAWANIE_AKTUALIZACJA("przelew druk (dodawanie / aktualizacja"),
	PRZELEW_DRUK_USUNIECIE("przelew druk (usunięcie)"),

// raport dyżur (definicja)
	RAPORT_DYZUR_DEF_DODAWANIE("raport z dyżuru (definicja - dodawanie)"),
	RAPORT_DYZUR_DEF_AKTUALIZACJA("raport z dyżuru (definicja - aktualizacja)"),
	RAPORT_DYZUR_DEF_USUNIECIE("raport z dyżuru (definicja - usunięcie)"),

// raport dyżur
	RAPORT_DYZUR_DODAWANIE_AKTUALIZACJA("raport z dyżuru (dodawanie/aktualizacja)"),
	RAPORT_DYZUR_USUNIECIE("raport z dyżuru (usunięcie)"),

// realizacja leków
	REALIZACJA_LEKOW_DODAWANIE_AKTUALIZACJA("realizacja leków (dodawanie/aktualizacja)"),
	REALIZACJA_LEKOW_USUNIECIE("realizacja leków (usunięcie)"),

// realizacja wyrobów medycznych
	REALIZACJA_WYROBOW_MED_DODAWANIE_AKTUALIZACJA("realizacja wyrobów medycznych (dodawanie/aktualizacja)"),
	REALIZACJA_WYROBOW_MED_USUNIECIE("realizacja wyrobów medycznych (usunięcie)"),

// realizacje recept
	RECEPTY_FAKTURY_DODAWANIE("realizacje leków (dodawanie)"),
	RECEPTY_FAKTURY_AKTUALIZACJA("realizacje leków (aktualizacja)"),
	RECEPTY_FAKTURY_USUNIECIE("realizacje leków (usunięcie)"),

// recepty
	RECEPTY_DODAWANIE_SZ("recepty (dodawanie)"),
	RECEPTY_DODAWANIE_IND("recepty (dodawanie)"),
	RECEPTY_AKTUALIZACJA("recepty (aktualizacja)"),
	RECEPTY_USUNIECIE("recepty (usunięcie)"),

// rodzaj świadczenia (słownik)
	RODZAJ_SWIADCZENIA_AKTUALIZACJA("rodzaj pob. świadczenia (aktualizacja"),

// skala oceny pacjenta
	SKALA_OCENY_DODAWANIE("skala oceny pacjenta (dodawanie)"),
	SKALA_OCENY_AKTUALIZACJA("skala oceny pacjenta (aktualizacja)"),
	SKALA_OCENY_USUNIECIE("skala oceny pacjenta (usunięcie)"),

// skala oceny - kryteria
	SKALA_KRYT_OPCJA_DODAWANIE_AKTUALIZACJA("skala oceny - kryterium opcja (dodawanie/aktualizacja)"),
	SKALA_KRYT_OPCJA_USUNIECIE("skala oceny - kryterium opcja (usunięcie)"),

// słownik leków
	SL_LEKOW_DODAWANIE("leki wykorzystywane (dodawanie)"),
	SL_LEKOW_USUNIECIE("leki wykorzystywane (usunięcie)"),

// słowo
	SLOWO_DODAWANIE_AKTUALIZACJA("słowo (dodawanie/aktualizacja)"),
	SLOWO_USUNIECIE("słowo (usunięcie)"),

// sprawozdanie
	SPRAWOZDANIE_DODAWANIE("sprawozdanie (dodawanie)"),
	SPRAWOZDANIE_AKTUALIZACJA("sprawozdanie (aktualiacja)"),
	SPRAWOZDANIE_USUNIECIE("sprawozdanie (usunięcie)"),

// świadczenie - definicja (w dziennym pobycie)
	SWIADCZENIE_GR_DODAWANIE_AKTUALIZACJA("grupa świadczeń (dodawanie/aktualizacja)"),
	SWIADCZENIE_GR_USUNIECIE("grupa świadczeń (usunięcie)"),
	SWIADCZENIE_DODAWANIE_AKTUALIZACJA("świadczenie (dodawanie/aktualizacja"),
	SWIADCZENIE_USUNIECIE("świadczenie (usunięcie)"),
	SWIADCZENIE_PLATNOSC_DODAWANIE_AKTUALIZACJA("odpłatność za świadczenie (dodawanie/aktualizacja"),
	SWIADCZENIE_ROZLICZENIE_DODAWANIE_AKTUALIZACJA("świadczenie - rozliczenie (dodawanie/aktualizacja)"),
	SWIADCZENIE_ROZLICZENIE_USUNIECIE("świadczenie - rozliczenie (usunięcie)"),
	SWIADCZENIE_ZWROT_DODAWANIE_AKTUALIZACJA("świadczenie - zwrot dla inst. (dodawanie/aktualizacja)"),

// szablon wydruku - blok ftl
	SZABLON_WYDRUKU_BLOK_USUNIECIE("szablon wydruku (usunięcie bloku FTL)"),

// szablon wydruku
	SZABLON_WYDRUKU_DODAWANIE_AKTUALIZACJA("szablon wydruku (dodawanie/aktualizacja)"),
	SZABLON_WYDRUKU_IMPORT("szablon wydruku (import)"),
	SZABLON_WYDRUKU_USUNIECIE("szablon wydruku (usunięcie)"),

// termin wypłaty
	TERMIN_WYPLATY_DODAWANIE_AKTUALIZACJA("termin wypłaty (dodawanie/aktualizacja)"),
	TERMIN_WYPLATY_USUNIECIE("termin wypłaty (usuniecie)"),

// decyzja kierująca
	UMOWA_DODAWANIE("umowa o pobyt (dodawanie)"),
	UMOWA_AKTUALIZACJA("umowa o pobyt (aktualizacja)"),
	UMOWA_USUNIECIE("umowa o pobyt (usunięcie)"),

// umowy a aptekami
	UMOWA_APTEKA_DODAWANIE_AKTUALIZACJA("umowa z apteką (dodawanie/aktualizacja)"),
	UMOWA_APTEKA_USUNIECIE("umowa z apteką (usunięcie)"),
	UMOWA_APTEKA_KWOTA_DODAWANIE_AKTUALIZACJA("umowa z apteką (kwoty - dodawanie/aktualizacja)"),
	UMOWA_APTEKA_KWOTA_USUNIECIE("umowa z apteką (kwoty - usunięcie)"),

// wpłaty mieszkańca za pobyt
	WPLATA_MIESZKANCA_DODAWANIE("wpłata mieszkańca (dodawanie)"),
	WPLATA_MIESZKANCA_AKTUALIZACJA("wpłata mieszkańca (aktualizacja)"),
	WPLATA_MIESZKANCA_USUNIECIE("wpłata mieszkańca (usunięcie)"),

// wyrób medyczny
	WYROB_MEDYCZNY_DODAWANIE_AKTUALIZACJA("wyrób medyczny (dodawanie / aktualizacja)"),
	WYROB_MEDYCZNY_USUNIECIE("wyrób medyczny (usunięcie)"),

// wyrób medyczny (faktura VAT)
	WYROB_MED_FAKTURY_DODAWANIE("faktura za wyrób medyczny (dodawanie)"),

// zapomoga
	ZAPOMOGA_DODAWANIE_AKTUALIZACJA("zapomoga (dodawanie/aktualizacja)"),
	ZAPOMOGA_USUNIECIE("zapomoga (usunięcie)"),

// zadanie czasowe
	ZADANIE_CZASOWE_AKTUALIZACJA("zadanie czasowe"),

// zebranie ZTO
	ZEBRANIE_ZTO_DODAWANIE_AKTUALIZACJA("zebranie ZTO (dodawanie / aktualizacja"),
	ZEBRANIE_ZTO_USUNIECIE("zebranie ZTO (usunięcie)"),

// zalecenia lekarskie
	ZALECENIE_LEKARSKIE_DODAWANIE_AKTUALIZACJA("zalecenie lekarskie (dodawanie/aktualizacja)"),
	ZALECENIE_LEKARSKIE_USUNIECIE("zalecenie lekarskie (usunięcie)"),

// zwroty
	ZWROT_DODAWANIE_AKTUALIZACJA("zwrot (dodawanie/aktualizacja)"),
	ZWROT_USUNIECIE("zwrot (usunięcie)"),
	;

	private String opis;

	private TypOperacji(String opis) {
		this.opis = opis;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
