package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

/**
 * Dla pola typ w OSOBA_RODZINA oznaczonego jako NULL należy przyjąć, że osoba
 * jest członkiem rodziny i powinno się wówczas brać pod uwagę stopień pokrewieństwa.
 * 
 * Jeżeli natomiast stopień pokrewieństwa jest ustawiony na 'inna - brak pokrewieństwa'
 * oznacza to wtedy, że powinna być wybrana któraś z wartości enuma {@link TypOsobyWRodzinie}.
 */
public enum TypOsobyWRodzinie implements EnumOpis {
	KURATOR_SADOWY("kurator sądowy"),
	OPIEKUN_PRAWNY("opiekun prawny"),
	PELNOMOCNIK_NOTARIALNY("pełnomocnik notarialny"),
	PLATNIK("płatnik za pobyt mieszkańca"),
	ZLECENIODAWCA_UMOWY("zleceniodawca umówy z fundacją")
	;
	
	private String opis;
	
	private TypOsobyWRodzinie(String opis) {
		this.opis = opis;
	}
	
	@Override
	public String getOpis() {
		return this.opis;
	}
}
